/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTlsInspectionConfigurationResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeTlsInspectionConfigurationResponse.Builder, DescribeTlsInspectionConfigurationResponse> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(DescribeTlsInspectionConfigurationResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<TLSInspectionConfiguration> TLS_INSPECTION_CONFIGURATION_FIELD = SdkField
            .<TLSInspectionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TLSInspectionConfiguration")
            .getter(getter(DescribeTlsInspectionConfigurationResponse::tlsInspectionConfiguration))
            .setter(setter(Builder::tlsInspectionConfiguration))
            .constructor(TLSInspectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfiguration").build())
            .build();

    private static final SdkField<TLSInspectionConfigurationResponse> TLS_INSPECTION_CONFIGURATION_RESPONSE_FIELD = SdkField
            .<TLSInspectionConfigurationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("TLSInspectionConfigurationResponse")
            .getter(getter(DescribeTlsInspectionConfigurationResponse::tlsInspectionConfigurationResponse))
            .setter(setter(Builder::tlsInspectionConfigurationResponse))
            .constructor(TLSInspectionConfigurationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationResponse")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            TLS_INSPECTION_CONFIGURATION_FIELD, TLS_INSPECTION_CONFIGURATION_RESPONSE_FIELD));

    private final String updateToken;

    private final TLSInspectionConfiguration tlsInspectionConfiguration;

    private final TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse;

    private DescribeTlsInspectionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.tlsInspectionConfiguration = builder.tlsInspectionConfiguration;
        this.tlsInspectionConfigurationResponse = builder.tlsInspectionConfigurationResponse;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS
     * inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of
     * the request.
     * </p>
     * <p>
     * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses
     * the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has
     * changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS
     * inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed,
     * then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at
     *         the time of the request. </p>
     *         <p>
     *         To make changes to the TLS inspection configuration, you provide the token in your request. Network
     *         Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last
     *         retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this
     *         happens, retrieve the TLS inspection configuration again to get a current copy of it with a current
     *         token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The object that defines a TLS inspection configuration. This, along with
     * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects
     * for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic
     * before sending it to its destination.
     * </p>
     * <p>
     * To use a TLS inspection configuration, you add it to a Network Firewall firewall policy, then you apply the
     * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic.
     * You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall
     * policy in more than one firewall. For more information about using TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * 
     * @return The object that defines a TLS inspection configuration. This, along with
     *         <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
     *         objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>
     *         <p>
     *         Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
     *         traffic before sending it to its destination.
     *         </p>
     *         <p>
     *         To use a TLS inspection configuration, you add it to a Network Firewall firewall policy, then you apply
     *         the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect
     *         inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and
     *         you can use a firewall policy in more than one firewall. For more information about using TLS inspection
     *         configurations, see <a
     *         href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
     *         SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     */
    public final TLSInspectionConfiguration tlsInspectionConfiguration() {
        return tlsInspectionConfiguration;
    }

    /**
     * <p>
     * The high-level properties of a TLS inspection configuration. This, along with the
     * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a
     * TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * 
     * @return The high-level properties of a TLS inspection configuration. This, along with the
     *         <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects
     *         for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     */
    public final TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse() {
        return tlsInspectionConfigurationResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTlsInspectionConfigurationResponse)) {
            return false;
        }
        DescribeTlsInspectionConfigurationResponse other = (DescribeTlsInspectionConfigurationResponse) obj;
        return Objects.equals(updateToken(), other.updateToken())
                && Objects.equals(tlsInspectionConfiguration(), other.tlsInspectionConfiguration())
                && Objects.equals(tlsInspectionConfigurationResponse(), other.tlsInspectionConfigurationResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTlsInspectionConfigurationResponse").add("UpdateToken", updateToken())
                .add("TLSInspectionConfiguration", tlsInspectionConfiguration())
                .add("TLSInspectionConfigurationResponse", tlsInspectionConfigurationResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "TLSInspectionConfiguration":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfiguration()));
        case "TLSInspectionConfigurationResponse":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTlsInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeTlsInspectionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTlsInspectionConfigurationResponse> {
        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS
         * inspection configuration. The token marks the state of the TLS inspection configuration resource at the time
         * of the request.
         * </p>
         * <p>
         * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall
         * uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If
         * it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
         * TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as
         * needed, then try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        TLS inspection configuration. The token marks the state of the TLS inspection configuration resource
         *        at the time of the request. </p>
         *        <p>
         *        To make changes to the TLS inspection configuration, you provide the token in your request. Network
         *        Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last
         *        retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If
         *        this happens, retrieve the TLS inspection configuration again to get a current copy of it with a
         *        current token. Reapply your changes as needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a Network Firewall firewall policy, then you apply the
         * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param tlsInspectionConfiguration
         *        The object that defines a TLS inspection configuration. This, along with
         *        <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve
         *        all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         *        </p>
         *        <p>
         *        Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts
         *        the traffic before sending it to its destination.
         *        </p>
         *        <p>
         *        To use a TLS inspection configuration, you add it to a Network Firewall firewall policy, then you
         *        apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and
         *        inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall
         *        policy, and you can use a firewall policy in more than one firewall. For more information about using
         *        TLS inspection configurations, see <a
         *        href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html"
         *        >Decrypting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a Network Firewall firewall policy, then you apply the
         * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TLSInspectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link TLSInspectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSInspectionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #tlsInspectionConfiguration(TLSInspectionConfiguration)}.
         * 
         * @param tlsInspectionConfiguration
         *        a consumer that will call methods on {@link TLSInspectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInspectionConfiguration(TLSInspectionConfiguration)
         */
        default Builder tlsInspectionConfiguration(Consumer<TLSInspectionConfiguration.Builder> tlsInspectionConfiguration) {
            return tlsInspectionConfiguration(TLSInspectionConfiguration.builder().applyMutation(tlsInspectionConfiguration)
                    .build());
        }

        /**
         * <p>
         * The high-level properties of a TLS inspection configuration. This, along with the
         * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for
         * a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * 
         * @param tlsInspectionConfigurationResponse
         *        The high-level properties of a TLS inspection configuration. This, along with the
         *        <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all
         *        objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse);

        /**
         * <p>
         * The high-level properties of a TLS inspection configuration. This, along with the
         * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for
         * a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TLSInspectionConfigurationResponse.Builder} avoiding the need to create one manually via
         * {@link TLSInspectionConfigurationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSInspectionConfigurationResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse)}.
         * 
         * @param tlsInspectionConfigurationResponse
         *        a consumer that will call methods on {@link TLSInspectionConfigurationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse)
         */
        default Builder tlsInspectionConfigurationResponse(
                Consumer<TLSInspectionConfigurationResponse.Builder> tlsInspectionConfigurationResponse) {
            return tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse.builder()
                    .applyMutation(tlsInspectionConfigurationResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String updateToken;

        private TLSInspectionConfiguration tlsInspectionConfiguration;

        private TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTlsInspectionConfigurationResponse model) {
            super(model);
            updateToken(model.updateToken);
            tlsInspectionConfiguration(model.tlsInspectionConfiguration);
            tlsInspectionConfigurationResponse(model.tlsInspectionConfigurationResponse);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final TLSInspectionConfiguration.Builder getTlsInspectionConfiguration() {
            return tlsInspectionConfiguration != null ? tlsInspectionConfiguration.toBuilder() : null;
        }

        public final void setTlsInspectionConfiguration(TLSInspectionConfiguration.BuilderImpl tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration != null ? tlsInspectionConfiguration.build() : null;
        }

        @Override
        public final Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        public final TLSInspectionConfigurationResponse.Builder getTlsInspectionConfigurationResponse() {
            return tlsInspectionConfigurationResponse != null ? tlsInspectionConfigurationResponse.toBuilder() : null;
        }

        public final void setTlsInspectionConfigurationResponse(
                TLSInspectionConfigurationResponse.BuilderImpl tlsInspectionConfigurationResponse) {
            this.tlsInspectionConfigurationResponse = tlsInspectionConfigurationResponse != null ? tlsInspectionConfigurationResponse
                    .build() : null;
        }

        @Override
        public final Builder tlsInspectionConfigurationResponse(
                TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse) {
            this.tlsInspectionConfigurationResponse = tlsInspectionConfigurationResponse;
            return this;
        }

        @Override
        public DescribeTlsInspectionConfigurationResponse build() {
            return new DescribeTlsInspectionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
