/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition;
import software.amazon.awssdk.services.neptunedata.model.MlResourceDefinition;
import software.amazon.awssdk.services.neptunedata.model.ModelsCopier;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlModelTransformJobResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetMlModelTransformJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMlModelTransformJobResponse.getter(GetMlModelTransformJobResponse::status)).setter(GetMlModelTransformJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetMlModelTransformJobResponse.getter(GetMlModelTransformJobResponse::id)).setter(GetMlModelTransformJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MlResourceDefinition> BASE_PROCESSING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("baseProcessingJob").getter(GetMlModelTransformJobResponse.getter(GetMlModelTransformJobResponse::baseProcessingJob)).setter(GetMlModelTransformJobResponse.setter(Builder::baseProcessingJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingJob").build()}).build();
    private static final SdkField<MlResourceDefinition> REMOTE_MODEL_TRANSFORM_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remoteModelTransformJob").getter(GetMlModelTransformJobResponse.getter(GetMlModelTransformJobResponse::remoteModelTransformJob)).setter(GetMlModelTransformJobResponse.setter(Builder::remoteModelTransformJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteModelTransformJob").build()}).build();
    private static final SdkField<List<MlConfigDefinition>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(GetMlModelTransformJobResponse.getter(GetMlModelTransformJobResponse::models)).setter(GetMlModelTransformJobResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MlConfigDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD, BASE_PROCESSING_JOB_FIELD, REMOTE_MODEL_TRANSFORM_JOB_FIELD, MODELS_FIELD));
    private final String status;
    private final String id;
    private final MlResourceDefinition baseProcessingJob;
    private final MlResourceDefinition remoteModelTransformJob;
    private final List<MlConfigDefinition> models;

    private GetMlModelTransformJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.baseProcessingJob = builder.baseProcessingJob;
        this.remoteModelTransformJob = builder.remoteModelTransformJob;
        this.models = builder.models;
    }

    public final String status() {
        return this.status;
    }

    public final String id() {
        return this.id;
    }

    public final MlResourceDefinition baseProcessingJob() {
        return this.baseProcessingJob;
    }

    public final MlResourceDefinition remoteModelTransformJob() {
        return this.remoteModelTransformJob;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<MlConfigDefinition> models() {
        return this.models;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseProcessingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteModelTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelTransformJobResponse)) {
            return false;
        }
        GetMlModelTransformJobResponse other = (GetMlModelTransformJobResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.baseProcessingJob(), other.baseProcessingJob()) && Objects.equals(this.remoteModelTransformJob(), other.remoteModelTransformJob()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlModelTransformJobResponse").add("Status", (Object)this.status()).add("Id", (Object)this.id()).add("BaseProcessingJob", (Object)this.baseProcessingJob()).add("RemoteModelTransformJob", (Object)this.remoteModelTransformJob()).add("Models", this.hasModels() ? this.models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "baseProcessingJob": {
                return Optional.ofNullable(clazz.cast(this.baseProcessingJob()));
            }
            case "remoteModelTransformJob": {
                return Optional.ofNullable(clazz.cast(this.remoteModelTransformJob()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelTransformJobResponse, T> g) {
        return obj -> g.apply((GetMlModelTransformJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String status;
        private String id;
        private MlResourceDefinition baseProcessingJob;
        private MlResourceDefinition remoteModelTransformJob;
        private List<MlConfigDefinition> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelTransformJobResponse model) {
            super(model);
            this.status(model.status);
            this.id(model.id);
            this.baseProcessingJob(model.baseProcessingJob);
            this.remoteModelTransformJob(model.remoteModelTransformJob);
            this.models(model.models);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getBaseProcessingJob() {
            return this.baseProcessingJob != null ? this.baseProcessingJob.toBuilder() : null;
        }

        public final void setBaseProcessingJob(MlResourceDefinition.BuilderImpl baseProcessingJob) {
            this.baseProcessingJob = baseProcessingJob != null ? baseProcessingJob.build() : null;
        }

        @Override
        public final Builder baseProcessingJob(MlResourceDefinition baseProcessingJob) {
            this.baseProcessingJob = baseProcessingJob;
            return this;
        }

        public final MlResourceDefinition.Builder getRemoteModelTransformJob() {
            return this.remoteModelTransformJob != null ? this.remoteModelTransformJob.toBuilder() : null;
        }

        public final void setRemoteModelTransformJob(MlResourceDefinition.BuilderImpl remoteModelTransformJob) {
            this.remoteModelTransformJob = remoteModelTransformJob != null ? remoteModelTransformJob.build() : null;
        }

        @Override
        public final Builder remoteModelTransformJob(MlResourceDefinition remoteModelTransformJob) {
            this.remoteModelTransformJob = remoteModelTransformJob;
            return this;
        }

        public final List<MlConfigDefinition.Builder> getModels() {
            List<MlConfigDefinition.Builder> result = ModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<MlConfigDefinition.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<MlConfigDefinition> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(MlConfigDefinition ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<MlConfigDefinition.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (MlConfigDefinition)((MlConfigDefinition.Builder)MlConfigDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMlModelTransformJobResponse build() {
            return new GetMlModelTransformJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlModelTransformJobResponse> {
        public Builder status(String var1);

        public Builder id(String var1);

        public Builder baseProcessingJob(MlResourceDefinition var1);

        default public Builder baseProcessingJob(Consumer<MlResourceDefinition.Builder> baseProcessingJob) {
            return this.baseProcessingJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(baseProcessingJob)).build());
        }

        public Builder remoteModelTransformJob(MlResourceDefinition var1);

        default public Builder remoteModelTransformJob(Consumer<MlResourceDefinition.Builder> remoteModelTransformJob) {
            return this.remoteModelTransformJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(remoteModelTransformJob)).build());
        }

        public Builder models(Collection<MlConfigDefinition> var1);

        public Builder models(MlConfigDefinition ... var1);

        public Builder models(Consumer<MlConfigDefinition.Builder> ... var1);
    }
}

