/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;

public class DescribeDBClusterParameterGroupsPublisher
implements SdkPublisher<DescribeDbClusterParameterGroupsResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbClusterParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterParameterGroupsPublisher(NeptuneAsyncClient client, DescribeDbClusterParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterParameterGroupsPublisher(NeptuneAsyncClient client, DescribeDbClusterParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBClusterParameterGroup> dbClusterParameterGroups() {
        Function<DescribeDbClusterParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterParameterGroups() != null) {
                return response.dbClusterParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterParameterGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterParameterGroupsResponse> {
        private DescribeDbClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterParameterGroupsResponse> nextPage(DescribeDbClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterParameterGroupsPublisher.this.client.describeDBClusterParameterGroups(DescribeDBClusterParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeDBClusterParameterGroupsPublisher.this.client.describeDBClusterParameterGroups((DescribeDbClusterParameterGroupsRequest)((Object)DescribeDBClusterParameterGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

