/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCliTokenResponse extends MwaaResponse implements
        ToCopyableBuilder<CreateCliTokenResponse.Builder, CreateCliTokenResponse> {
    private static final SdkField<String> CLI_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CliToken").getter(getter(CreateCliTokenResponse::cliToken)).setter(setter(Builder::cliToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CliToken").build()).build();

    private static final SdkField<String> WEB_SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebServerHostname").getter(getter(CreateCliTokenResponse::webServerHostname))
            .setter(setter(Builder::webServerHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebServerHostname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLI_TOKEN_FIELD,
            WEB_SERVER_HOSTNAME_FIELD));

    private final String cliToken;

    private final String webServerHostname;

    private CreateCliTokenResponse(BuilderImpl builder) {
        super(builder);
        this.cliToken = builder.cliToken;
        this.webServerHostname = builder.webServerHostname;
    }

    /**
     * <p>
     * An Airflow CLI login token.
     * </p>
     * 
     * @return An Airflow CLI login token.
     */
    public final String cliToken() {
        return cliToken;
    }

    /**
     * <p>
     * The Airflow web server hostname for the environment.
     * </p>
     * 
     * @return The Airflow web server hostname for the environment.
     */
    public final String webServerHostname() {
        return webServerHostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cliToken());
        hashCode = 31 * hashCode + Objects.hashCode(webServerHostname());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCliTokenResponse)) {
            return false;
        }
        CreateCliTokenResponse other = (CreateCliTokenResponse) obj;
        return Objects.equals(cliToken(), other.cliToken()) && Objects.equals(webServerHostname(), other.webServerHostname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCliTokenResponse")
                .add("CliToken", cliToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebServerHostname", webServerHostname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CliToken":
            return Optional.ofNullable(clazz.cast(cliToken()));
        case "WebServerHostname":
            return Optional.ofNullable(clazz.cast(webServerHostname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCliTokenResponse, T> g) {
        return obj -> g.apply((CreateCliTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MwaaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCliTokenResponse> {
        /**
         * <p>
         * An Airflow CLI login token.
         * </p>
         * 
         * @param cliToken
         *        An Airflow CLI login token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cliToken(String cliToken);

        /**
         * <p>
         * The Airflow web server hostname for the environment.
         * </p>
         * 
         * @param webServerHostname
         *        The Airflow web server hostname for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webServerHostname(String webServerHostname);
    }

    static final class BuilderImpl extends MwaaResponse.BuilderImpl implements Builder {
        private String cliToken;

        private String webServerHostname;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCliTokenResponse model) {
            super(model);
            cliToken(model.cliToken);
            webServerHostname(model.webServerHostname);
        }

        public final String getCliToken() {
            return cliToken;
        }

        public final void setCliToken(String cliToken) {
            this.cliToken = cliToken;
        }

        @Override
        public final Builder cliToken(String cliToken) {
            this.cliToken = cliToken;
            return this;
        }

        public final String getWebServerHostname() {
            return webServerHostname;
        }

        public final void setWebServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
        }

        @Override
        public final Builder webServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
            return this;
        }

        @Override
        public CreateCliTokenResponse build() {
            return new CreateCliTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
