/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.LoggingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModuleLoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModuleLoggingConfiguration> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(ModuleLoggingConfiguration.getter(ModuleLoggingConfiguration::cloudWatchLogGroupArn)).setter(ModuleLoggingConfiguration.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(ModuleLoggingConfiguration.getter(ModuleLoggingConfiguration::enabled)).setter(ModuleLoggingConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(ModuleLoggingConfiguration.getter(ModuleLoggingConfiguration::logLevelAsString)).setter(ModuleLoggingConfiguration.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_GROUP_ARN_FIELD, ENABLED_FIELD, LOG_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLogGroupArn;
    private final Boolean enabled;
    private final String logLevel;

    private ModuleLoggingConfiguration(BuilderImpl builder) {
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.enabled = builder.enabled;
        this.logLevel = builder.logLevel;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final LoggingLevel logLevel() {
        return LoggingLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleLoggingConfiguration)) {
            return false;
        }
        ModuleLoggingConfiguration other = (ModuleLoggingConfiguration)obj;
        return Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModuleLoggingConfiguration").add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("Enabled", (Object)this.enabled()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModuleLoggingConfiguration, T> g) {
        return obj -> g.apply((ModuleLoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogGroupArn;
        private Boolean enabled;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleLoggingConfiguration model) {
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.enabled(model.enabled);
            this.logLevel(model.logLevel);
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LoggingLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public ModuleLoggingConfiguration build() {
            return new ModuleLoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModuleLoggingConfiguration> {
        public Builder cloudWatchLogGroupArn(String var1);

        public Builder enabled(Boolean var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LoggingLevel var1);
    }
}

