/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBonusPaymentsResponse extends MTurkResponse implements
        ToCopyableBuilder<ListBonusPaymentsResponse.Builder, ListBonusPaymentsResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumResults").getter(getter(ListBonusPaymentsResponse::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBonusPaymentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BonusPayment>> BONUS_PAYMENTS_FIELD = SdkField
            .<List<BonusPayment>> builder(MarshallingType.LIST)
            .memberName("BonusPayments")
            .getter(getter(ListBonusPaymentsResponse::bonusPayments))
            .setter(setter(Builder::bonusPayments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BonusPayments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BonusPayment> builder(MarshallingType.SDK_POJO)
                                            .constructor(BonusPayment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, BONUS_PAYMENTS_FIELD));

    private final Integer numResults;

    private final String nextToken;

    private final List<BonusPayment> bonusPayments;

    private ListBonusPaymentsResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.bonusPayments = builder.bonusPayments;
    }

    /**
     * <p>
     * The number of bonus payments on this page in the filtered results list, equivalent to the number of bonus
     * payments being returned by this call.
     * </p>
     * 
     * @return The number of bonus payments on this page in the filtered results list, equivalent to the number of bonus
     *         payments being returned by this call.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BonusPayments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBonusPayments() {
        return bonusPayments != null && !(bonusPayments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBonusPayments} method.
     * </p>
     * 
     * @return A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
     */
    public final List<BonusPayment> bonusPayments() {
        return bonusPayments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBonusPayments() ? bonusPayments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBonusPaymentsResponse)) {
            return false;
        }
        ListBonusPaymentsResponse other = (ListBonusPaymentsResponse) obj;
        return Objects.equals(numResults(), other.numResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasBonusPayments() == other.hasBonusPayments() && Objects.equals(bonusPayments(), other.bonusPayments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBonusPaymentsResponse").add("NumResults", numResults()).add("NextToken", nextToken())
                .add("BonusPayments", hasBonusPayments() ? bonusPayments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BonusPayments":
            return Optional.ofNullable(clazz.cast(bonusPayments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBonusPaymentsResponse, T> g) {
        return obj -> g.apply((ListBonusPaymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBonusPaymentsResponse> {
        /**
         * <p>
         * The number of bonus payments on this page in the filtered results list, equivalent to the number of bonus
         * payments being returned by this call.
         * </p>
         * 
         * @param numResults
         *        The number of bonus payments on this page in the filtered results list, equivalent to the number of
         *        bonus payments being returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
         * </p>
         * 
         * @param bonusPayments
         *        A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bonusPayments(Collection<BonusPayment> bonusPayments);

        /**
         * <p>
         * A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
         * </p>
         * 
         * @param bonusPayments
         *        A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bonusPayments(BonusPayment... bonusPayments);

        /**
         * <p>
         * A successful request to the ListBonusPayments operation returns a list of BonusPayment objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mturk.model.BonusPayment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mturk.model.BonusPayment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mturk.model.BonusPayment.Builder#build()} is called immediately and
         * its result is passed to {@link #bonusPayments(List<BonusPayment>)}.
         * 
         * @param bonusPayments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mturk.model.BonusPayment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bonusPayments(java.util.Collection<BonusPayment>)
         */
        Builder bonusPayments(Consumer<BonusPayment.Builder>... bonusPayments);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private Integer numResults;

        private String nextToken;

        private List<BonusPayment> bonusPayments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBonusPaymentsResponse model) {
            super(model);
            numResults(model.numResults);
            nextToken(model.nextToken);
            bonusPayments(model.bonusPayments);
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BonusPayment.Builder> getBonusPayments() {
            List<BonusPayment.Builder> result = BonusPaymentListCopier.copyToBuilder(this.bonusPayments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBonusPayments(Collection<BonusPayment.BuilderImpl> bonusPayments) {
            this.bonusPayments = BonusPaymentListCopier.copyFromBuilder(bonusPayments);
        }

        @Override
        public final Builder bonusPayments(Collection<BonusPayment> bonusPayments) {
            this.bonusPayments = BonusPaymentListCopier.copy(bonusPayments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bonusPayments(BonusPayment... bonusPayments) {
            bonusPayments(Arrays.asList(bonusPayments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bonusPayments(Consumer<BonusPayment.Builder>... bonusPayments) {
            bonusPayments(Stream.of(bonusPayments).map(c -> BonusPayment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBonusPaymentsResponse build() {
            return new ListBonusPaymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
