/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a Bonus payment paid to a Worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BonusPayment implements SdkPojo, Serializable, ToCopyableBuilder<BonusPayment.Builder, BonusPayment> {
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerId").getter(getter(BonusPayment::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()).build();

    private static final SdkField<String> BONUS_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BonusAmount").getter(getter(BonusPayment::bonusAmount)).setter(setter(Builder::bonusAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BonusAmount").build()).build();

    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentId").getter(getter(BonusPayment::assignmentId)).setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(BonusPayment::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<Instant> GRANT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("GrantTime").getter(getter(BonusPayment::grantTime)).setter(setter(Builder::grantTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_ID_FIELD,
            BONUS_AMOUNT_FIELD, ASSIGNMENT_ID_FIELD, REASON_FIELD, GRANT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workerId;

    private final String bonusAmount;

    private final String assignmentId;

    private final String reason;

    private final Instant grantTime;

    private BonusPayment(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.bonusAmount = builder.bonusAmount;
        this.assignmentId = builder.assignmentId;
        this.reason = builder.reason;
        this.grantTime = builder.grantTime;
    }

    /**
     * <p>
     * The ID of the Worker to whom the bonus was paid.
     * </p>
     * 
     * @return The ID of the Worker to whom the bonus was paid.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * Returns the value of the BonusAmount property for this object.
     * 
     * @return The value of the BonusAmount property for this object.
     */
    public final String bonusAmount() {
        return bonusAmount;
    }

    /**
     * <p>
     * The ID of the assignment associated with this bonus payment.
     * </p>
     * 
     * @return The ID of the assignment associated with this bonus payment.
     */
    public final String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * The Reason text given when the bonus was granted, if any.
     * </p>
     * 
     * @return The Reason text given when the bonus was granted, if any.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The date and time of when the bonus was granted.
     * </p>
     * 
     * @return The date and time of when the bonus was granted.
     */
    public final Instant grantTime() {
        return grantTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(bonusAmount());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(grantTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BonusPayment)) {
            return false;
        }
        BonusPayment other = (BonusPayment) obj;
        return Objects.equals(workerId(), other.workerId()) && Objects.equals(bonusAmount(), other.bonusAmount())
                && Objects.equals(assignmentId(), other.assignmentId()) && Objects.equals(reason(), other.reason())
                && Objects.equals(grantTime(), other.grantTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BonusPayment").add("WorkerId", workerId()).add("BonusAmount", bonusAmount())
                .add("AssignmentId", assignmentId()).add("Reason", reason()).add("GrantTime", grantTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "BonusAmount":
            return Optional.ofNullable(clazz.cast(bonusAmount()));
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "GrantTime":
            return Optional.ofNullable(clazz.cast(grantTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BonusPayment, T> g) {
        return obj -> g.apply((BonusPayment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BonusPayment> {
        /**
         * <p>
         * The ID of the Worker to whom the bonus was paid.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker to whom the bonus was paid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * Sets the value of the BonusAmount property for this object.
         *
         * @param bonusAmount
         *        The new value for the BonusAmount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bonusAmount(String bonusAmount);

        /**
         * <p>
         * The ID of the assignment associated with this bonus payment.
         * </p>
         * 
         * @param assignmentId
         *        The ID of the assignment associated with this bonus payment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * The Reason text given when the bonus was granted, if any.
         * </p>
         * 
         * @param reason
         *        The Reason text given when the bonus was granted, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The date and time of when the bonus was granted.
         * </p>
         * 
         * @param grantTime
         *        The date and time of when the bonus was granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTime(Instant grantTime);
    }

    static final class BuilderImpl implements Builder {
        private String workerId;

        private String bonusAmount;

        private String assignmentId;

        private String reason;

        private Instant grantTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BonusPayment model) {
            workerId(model.workerId);
            bonusAmount(model.bonusAmount);
            assignmentId(model.assignmentId);
            reason(model.reason);
            grantTime(model.grantTime);
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getBonusAmount() {
            return bonusAmount;
        }

        public final void setBonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
        }

        @Override
        public final Builder bonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
            return this;
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getGrantTime() {
            return grantTime;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        @Override
        public BonusPayment build() {
            return new BonusPayment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
