/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.QualificationRequest;
import software.amazon.awssdk.services.mturk.model.QualificationRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQualificationRequestsResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListQualificationRequestsResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListQualificationRequestsResponse.getter(ListQualificationRequestsResponse::numResults)).setter(ListQualificationRequestsResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQualificationRequestsResponse.getter(ListQualificationRequestsResponse::nextToken)).setter(ListQualificationRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QualificationRequest>> QUALIFICATION_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QualificationRequests").getter(ListQualificationRequestsResponse.getter(ListQualificationRequestsResponse::qualificationRequests)).setter(ListQualificationRequestsResponse.setter(Builder::qualificationRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QualificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD, NEXT_TOKEN_FIELD, QUALIFICATION_REQUESTS_FIELD));
    private final Integer numResults;
    private final String nextToken;
    private final List<QualificationRequest> qualificationRequests;

    private ListQualificationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.qualificationRequests = builder.qualificationRequests;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQualificationRequests() {
        return this.qualificationRequests != null && !(this.qualificationRequests instanceof SdkAutoConstructList);
    }

    public final List<QualificationRequest> qualificationRequests() {
        return this.qualificationRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualificationRequests() ? this.qualificationRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationRequestsResponse)) {
            return false;
        }
        ListQualificationRequestsResponse other = (ListQualificationRequestsResponse)((Object)obj);
        return Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasQualificationRequests() == other.hasQualificationRequests() && Objects.equals(this.qualificationRequests(), other.qualificationRequests());
    }

    public final String toString() {
        return ToString.builder((String)"ListQualificationRequestsResponse").add("NumResults", (Object)this.numResults()).add("NextToken", (Object)this.nextToken()).add("QualificationRequests", this.hasQualificationRequests() ? this.qualificationRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QualificationRequests": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationRequestsResponse, T> g) {
        return obj -> g.apply((ListQualificationRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private Integer numResults;
        private String nextToken;
        private List<QualificationRequest> qualificationRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationRequestsResponse model) {
            super(model);
            this.numResults(model.numResults);
            this.nextToken(model.nextToken);
            this.qualificationRequests(model.qualificationRequests);
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QualificationRequest.Builder> getQualificationRequests() {
            if (this.qualificationRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.qualificationRequests != null ? (Collection)this.qualificationRequests.stream().map(QualificationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationRequests(Collection<QualificationRequest> qualificationRequests) {
            this.qualificationRequests = QualificationRequestListCopier.copy(qualificationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequests(QualificationRequest ... qualificationRequests) {
            this.qualificationRequests(Arrays.asList(qualificationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequests(Consumer<QualificationRequest.Builder> ... qualificationRequests) {
            this.qualificationRequests(Stream.of(qualificationRequests).map(c -> (QualificationRequest)((QualificationRequest.Builder)QualificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequests(Collection<QualificationRequest.BuilderImpl> qualificationRequests) {
            this.qualificationRequests = QualificationRequestListCopier.copyFromBuilder(qualificationRequests);
        }

        @Override
        public ListQualificationRequestsResponse build() {
            return new ListQualificationRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQualificationRequestsResponse> {
        public Builder numResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder qualificationRequests(Collection<QualificationRequest> var1);

        public Builder qualificationRequests(QualificationRequest ... var1);

        public Builder qualificationRequests(Consumer<QualificationRequest.Builder> ... var1);
    }
}

