/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HITAccessActions {
    ACCEPT("Accept"),
    PREVIEW_AND_ACCEPT("PreviewAndAccept"),
    DISCOVER_PREVIEW_AND_ACCEPT("DiscoverPreviewAndAccept"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HITAccessActions(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HITAccessActions fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HITAccessActions.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HITAccessActions> knownValues() {
        return Stream.of(HITAccessActions.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

