/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.___listOfConfigurationRevisionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationRevisionsResponse
extends MqResponse
implements ToCopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationId").getter(ListConfigurationRevisionsResponse.getter(ListConfigurationRevisionsResponse::configurationId)).setter(ListConfigurationRevisionsResponse.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListConfigurationRevisionsResponse.getter(ListConfigurationRevisionsResponse::maxResults)).setter(ListConfigurationRevisionsResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationRevisionsResponse.getter(ListConfigurationRevisionsResponse::nextToken)).setter(ListConfigurationRevisionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ConfigurationRevision>> REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Revisions").getter(ListConfigurationRevisionsResponse.getter(ListConfigurationRevisionsResponse::revisions)).setter(ListConfigurationRevisionsResponse.setter(Builder::revisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REVISIONS_FIELD));
    private final String configurationId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<ConfigurationRevision> revisions;

    private ListConfigurationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    public final String configurationId() {
        return this.configurationId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRevisions() {
        return this.revisions != null && !(this.revisions instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationRevision> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisions() ? this.revisions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRevisionsResponse)) {
            return false;
        }
        ListConfigurationRevisionsResponse other = (ListConfigurationRevisionsResponse)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRevisions() == other.hasRevisions() && Objects.equals(this.revisions(), other.revisions());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationRevisionsResponse").add("ConfigurationId", (Object)this.configurationId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Revisions", this.hasRevisions() ? this.revisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Revisions": {
                return Optional.ofNullable(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationRevisionsResponse, T> g) {
        return obj -> g.apply((ListConfigurationRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String configurationId;
        private Integer maxResults;
        private String nextToken;
        private List<ConfigurationRevision> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRevisionsResponse model) {
            super(model);
            this.configurationId(model.configurationId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.revisions(model.revisions);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfigurationRevision.Builder> getRevisions() {
            List<ConfigurationRevision.Builder> result = ___listOfConfigurationRevisionCopier.copyToBuilder(this.revisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisions(Collection<ConfigurationRevision.BuilderImpl> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copyFromBuilder(revisions);
        }

        @Override
        public final Builder revisions(Collection<ConfigurationRevision> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(ConfigurationRevision ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<ConfigurationRevision.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfigurationRevisionsResponse build() {
            return new ListConfigurationRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
        public Builder configurationId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder revisions(Collection<ConfigurationRevision> var1);

        public Builder revisions(ConfigurationRevision ... var1);

        public Builder revisions(Consumer<ConfigurationRevision.Builder> ... var1);
    }
}

