/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrokerStorageType {
    EBS("EBS"),
    EFS("EFS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrokerStorageType> VALUE_MAP;
    private final String value;

    private BrokerStorageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrokerStorageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrokerStorageType> knownValues() {
        EnumSet<BrokerStorageType> knownValues = EnumSet.allOf(BrokerStorageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrokerStorageType.class, BrokerStorageType::toString);
    }
}

