/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mobile.DefaultMobileAsyncClient;
import software.amazon.awssdk.services.mobile.DefaultMobileBaseClientBuilder;
import software.amazon.awssdk.services.mobile.MobileAsyncClient;
import software.amazon.awssdk.services.mobile.MobileAsyncClientBuilder;
import software.amazon.awssdk.services.mobile.MobileServiceClientConfiguration;
import software.amazon.awssdk.services.mobile.endpoints.MobileEndpointProvider;

@SdkInternalApi
final class DefaultMobileAsyncClientBuilder
extends DefaultMobileBaseClientBuilder<MobileAsyncClientBuilder, MobileAsyncClient>
implements MobileAsyncClientBuilder {
    DefaultMobileAsyncClientBuilder() {
    }

    @Override
    public DefaultMobileAsyncClientBuilder endpointProvider(MobileEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MobileAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMobileAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MobileServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMobileAsyncClient client = new DefaultMobileAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MobileServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MobileServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

