/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationComponentCriteria {
    NOT_DEFINED("NOT_DEFINED"),
    APP_NAME("APP_NAME"),
    SERVER_ID("SERVER_ID"),
    APP_TYPE("APP_TYPE"),
    STRATEGY("STRATEGY"),
    DESTINATION("DESTINATION"),
    ANALYSIS_STATUS("ANALYSIS_STATUS"),
    ERROR_CATEGORY("ERROR_CATEGORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationComponentCriteria> VALUE_MAP;
    private final String value;

    private ApplicationComponentCriteria(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationComponentCriteria fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationComponentCriteria> knownValues() {
        EnumSet<ApplicationComponentCriteria> knownValues = EnumSet.allOf(ApplicationComponentCriteria.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationComponentCriteria.class, ApplicationComponentCriteria::toString);
    }
}

