/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollectorsResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<ListCollectorsResponse.Builder, ListCollectorsResponse> {
    private static final SdkField<List<Collector>> COLLECTORS_FIELD = SdkField
            .<List<Collector>> builder(MarshallingType.LIST)
            .memberName("Collectors")
            .getter(getter(ListCollectorsResponse::collectors))
            .setter(setter(Builder::collectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Collector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Collector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Collector> collectors;

    private final String nextToken;

    private ListCollectorsResponse(BuilderImpl builder) {
        super(builder);
        this.collectors = builder.collectors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Collectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCollectors() {
        return collectors != null && !(collectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of all the installed collectors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectors} method.
     * </p>
     * 
     * @return The list of all the installed collectors.
     */
    public final List<Collector> collectors() {
        return collectors;
    }

    /**
     * <p>
     * The token you use to retrieve the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token you use to retrieve the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectors() ? collectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectorsResponse)) {
            return false;
        }
        ListCollectorsResponse other = (ListCollectorsResponse) obj;
        return hasCollectors() == other.hasCollectors() && Objects.equals(collectors(), other.collectors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCollectorsResponse").add("Collectors", hasCollectors() ? collectors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Collectors":
            return Optional.ofNullable(clazz.cast(collectors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollectorsResponse, T> g) {
        return obj -> g.apply((ListCollectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollectorsResponse> {
        /**
         * <p>
         * The list of all the installed collectors.
         * </p>
         * 
         * @param collectors
         *        The list of all the installed collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectors(Collection<Collector> collectors);

        /**
         * <p>
         * The list of all the installed collectors.
         * </p>
         * 
         * @param collectors
         *        The list of all the installed collectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectors(Collector... collectors);

        /**
         * <p>
         * The list of all the installed collectors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Collector.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Collector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Collector.Builder#build()} is called
         * immediately and its result is passed to {@link #collectors(List<Collector>)}.
         * 
         * @param collectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.Collector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectors(java.util.Collection<Collector>)
         */
        Builder collectors(Consumer<Collector.Builder>... collectors);

        /**
         * <p>
         * The token you use to retrieve the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token you use to retrieve the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<Collector> collectors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectorsResponse model) {
            super(model);
            collectors(model.collectors);
            nextToken(model.nextToken);
        }

        public final List<Collector.Builder> getCollectors() {
            List<Collector.Builder> result = CollectorsCopier.copyToBuilder(this.collectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectors(Collection<Collector.BuilderImpl> collectors) {
            this.collectors = CollectorsCopier.copyFromBuilder(collectors);
        }

        @Override
        public final Builder collectors(Collection<Collector> collectors) {
            this.collectors = CollectorsCopier.copy(collectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Collector... collectors) {
            collectors(Arrays.asList(collectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Consumer<Collector.Builder>... collectors) {
            collectors(Stream.of(collectors).map(c -> Collector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollectorsResponse build() {
            return new ListCollectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
