/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssessmentResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetAssessmentResponse.Builder, GetAssessmentResponse> {
    private static final SdkField<List<AssessmentTarget>> ASSESSMENT_TARGETS_FIELD = SdkField
            .<List<AssessmentTarget>> builder(MarshallingType.LIST)
            .memberName("assessmentTargets")
            .getter(getter(GetAssessmentResponse::assessmentTargets))
            .setter(setter(Builder::assessmentTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataCollectionDetails> DATA_COLLECTION_DETAILS_FIELD = SdkField
            .<DataCollectionDetails> builder(MarshallingType.SDK_POJO).memberName("dataCollectionDetails")
            .getter(getter(GetAssessmentResponse::dataCollectionDetails)).setter(setter(Builder::dataCollectionDetails))
            .constructor(DataCollectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionDetails").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAssessmentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGETS_FIELD,
            DATA_COLLECTION_DETAILS_FIELD, ID_FIELD));

    private final List<AssessmentTarget> assessmentTargets;

    private final DataCollectionDetails dataCollectionDetails;

    private final String id;

    private GetAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargets = builder.assessmentTargets;
        this.dataCollectionDetails = builder.dataCollectionDetails;
        this.id = builder.id;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentTargets() {
        return assessmentTargets != null && !(assessmentTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of criteria for assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentTargets} method.
     * </p>
     * 
     * @return List of criteria for assessment.
     */
    public final List<AssessmentTarget> assessmentTargets() {
        return assessmentTargets;
    }

    /**
     * <p>
     * Detailed information about the assessment.
     * </p>
     * 
     * @return Detailed information about the assessment.
     */
    public final DataCollectionDetails dataCollectionDetails() {
        return dataCollectionDetails;
    }

    /**
     * <p>
     * The ID for the specific assessment task.
     * </p>
     * 
     * @return The ID for the specific assessment task.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentTargets() ? assessmentTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataCollectionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentResponse)) {
            return false;
        }
        GetAssessmentResponse other = (GetAssessmentResponse) obj;
        return hasAssessmentTargets() == other.hasAssessmentTargets()
                && Objects.equals(assessmentTargets(), other.assessmentTargets())
                && Objects.equals(dataCollectionDetails(), other.dataCollectionDetails()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssessmentResponse")
                .add("AssessmentTargets", hasAssessmentTargets() ? assessmentTargets() : null)
                .add("DataCollectionDetails", dataCollectionDetails()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargets":
            return Optional.ofNullable(clazz.cast(assessmentTargets()));
        case "dataCollectionDetails":
            return Optional.ofNullable(clazz.cast(dataCollectionDetails()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentResponse, T> g) {
        return obj -> g.apply((GetAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssessmentResponse> {
        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * 
         * @param assessmentTargets
         *        List of criteria for assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets);

        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * 
         * @param assessmentTargets
         *        List of criteria for assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(AssessmentTarget... assessmentTargets);

        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentTargets(List<AssessmentTarget>)}.
         * 
         * @param assessmentTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentTargets(java.util.Collection<AssessmentTarget>)
         */
        Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets);

        /**
         * <p>
         * Detailed information about the assessment.
         * </p>
         * 
         * @param dataCollectionDetails
         *        Detailed information about the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCollectionDetails(DataCollectionDetails dataCollectionDetails);

        /**
         * <p>
         * Detailed information about the assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCollectionDetails.Builder} avoiding
         * the need to create one manually via {@link DataCollectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCollectionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #dataCollectionDetails(DataCollectionDetails)}.
         * 
         * @param dataCollectionDetails
         *        a consumer that will call methods on {@link DataCollectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCollectionDetails(DataCollectionDetails)
         */
        default Builder dataCollectionDetails(Consumer<DataCollectionDetails.Builder> dataCollectionDetails) {
            return dataCollectionDetails(DataCollectionDetails.builder().applyMutation(dataCollectionDetails).build());
        }

        /**
         * <p>
         * The ID for the specific assessment task.
         * </p>
         * 
         * @param id
         *        The ID for the specific assessment task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<AssessmentTarget> assessmentTargets = DefaultSdkAutoConstructList.getInstance();

        private DataCollectionDetails dataCollectionDetails;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentResponse model) {
            super(model);
            assessmentTargets(model.assessmentTargets);
            dataCollectionDetails(model.dataCollectionDetails);
            id(model.id);
        }

        public final List<AssessmentTarget.Builder> getAssessmentTargets() {
            List<AssessmentTarget.Builder> result = AssessmentTargetsCopier.copyToBuilder(this.assessmentTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentTargets(Collection<AssessmentTarget.BuilderImpl> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copyFromBuilder(assessmentTargets);
        }

        @Override
        public final Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copy(assessmentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(AssessmentTarget... assessmentTargets) {
            assessmentTargets(Arrays.asList(assessmentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets) {
            assessmentTargets(Stream.of(assessmentTargets).map(c -> AssessmentTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataCollectionDetails.Builder getDataCollectionDetails() {
            return dataCollectionDetails != null ? dataCollectionDetails.toBuilder() : null;
        }

        public final void setDataCollectionDetails(DataCollectionDetails.BuilderImpl dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails != null ? dataCollectionDetails.build() : null;
        }

        @Override
        public final Builder dataCollectionDetails(DataCollectionDetails dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetAssessmentResponse build() {
            return new GetAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
