/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiGatewayProxyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiGatewayProxyConfig> {
    private static final SdkField<String> API_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiGatewayId").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::apiGatewayId)).setter(ApiGatewayProxyConfig.setter(Builder::apiGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayId").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::endpointTypeAsString)).setter(ApiGatewayProxyConfig.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> NLB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NlbArn").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::nlbArn)).setter(ApiGatewayProxyConfig.setter(Builder::nlbArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NlbArn").build()}).build();
    private static final SdkField<String> NLB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NlbName").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::nlbName)).setter(ApiGatewayProxyConfig.setter(Builder::nlbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NlbName").build()}).build();
    private static final SdkField<String> PROXY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyUrl").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::proxyUrl)).setter(ApiGatewayProxyConfig.setter(Builder::proxyUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyUrl").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::stageName)).setter(ApiGatewayProxyConfig.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcLinkId").getter(ApiGatewayProxyConfig.getter(ApiGatewayProxyConfig::vpcLinkId)).setter(ApiGatewayProxyConfig.setter(Builder::vpcLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcLinkId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_ID_FIELD, ENDPOINT_TYPE_FIELD, NLB_ARN_FIELD, NLB_NAME_FIELD, PROXY_URL_FIELD, STAGE_NAME_FIELD, VPC_LINK_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiGatewayId;
    private final String endpointType;
    private final String nlbArn;
    private final String nlbName;
    private final String proxyUrl;
    private final String stageName;
    private final String vpcLinkId;

    private ApiGatewayProxyConfig(BuilderImpl builder) {
        this.apiGatewayId = builder.apiGatewayId;
        this.endpointType = builder.endpointType;
        this.nlbArn = builder.nlbArn;
        this.nlbName = builder.nlbName;
        this.proxyUrl = builder.proxyUrl;
        this.stageName = builder.stageName;
        this.vpcLinkId = builder.vpcLinkId;
    }

    public final String apiGatewayId() {
        return this.apiGatewayId;
    }

    public final ApiGatewayEndpointType endpointType() {
        return ApiGatewayEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String nlbArn() {
        return this.nlbArn;
    }

    public final String nlbName() {
        return this.nlbName;
    }

    public final String proxyUrl() {
        return this.proxyUrl;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String vpcLinkId() {
        return this.vpcLinkId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nlbArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nlbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayProxyConfig)) {
            return false;
        }
        ApiGatewayProxyConfig other = (ApiGatewayProxyConfig)obj;
        return Objects.equals(this.apiGatewayId(), other.apiGatewayId()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.nlbArn(), other.nlbArn()) && Objects.equals(this.nlbName(), other.nlbName()) && Objects.equals(this.proxyUrl(), other.proxyUrl()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.vpcLinkId(), other.vpcLinkId());
    }

    public final String toString() {
        return ToString.builder((String)"ApiGatewayProxyConfig").add("ApiGatewayId", (Object)this.apiGatewayId()).add("EndpointType", (Object)this.endpointTypeAsString()).add("NlbArn", (Object)this.nlbArn()).add("NlbName", (Object)this.nlbName()).add("ProxyUrl", (Object)this.proxyUrl()).add("StageName", (Object)this.stageName()).add("VpcLinkId", (Object)this.vpcLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayId": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayId()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "NlbArn": {
                return Optional.ofNullable(clazz.cast(this.nlbArn()));
            }
            case "NlbName": {
                return Optional.ofNullable(clazz.cast(this.nlbName()));
            }
            case "ProxyUrl": {
                return Optional.ofNullable(clazz.cast(this.proxyUrl()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "VpcLinkId": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayProxyConfig, T> g) {
        return obj -> g.apply((ApiGatewayProxyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiGatewayId;
        private String endpointType;
        private String nlbArn;
        private String nlbName;
        private String proxyUrl;
        private String stageName;
        private String vpcLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayProxyConfig model) {
            this.apiGatewayId(model.apiGatewayId);
            this.endpointType(model.endpointType);
            this.nlbArn(model.nlbArn);
            this.nlbName(model.nlbName);
            this.proxyUrl(model.proxyUrl);
            this.stageName(model.stageName);
            this.vpcLinkId(model.vpcLinkId);
        }

        public final String getApiGatewayId() {
            return this.apiGatewayId;
        }

        public final void setApiGatewayId(String apiGatewayId) {
            this.apiGatewayId = apiGatewayId;
        }

        @Override
        public final Builder apiGatewayId(String apiGatewayId) {
            this.apiGatewayId = apiGatewayId;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ApiGatewayEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getNlbArn() {
            return this.nlbArn;
        }

        public final void setNlbArn(String nlbArn) {
            this.nlbArn = nlbArn;
        }

        @Override
        public final Builder nlbArn(String nlbArn) {
            this.nlbArn = nlbArn;
            return this;
        }

        public final String getNlbName() {
            return this.nlbName;
        }

        public final void setNlbName(String nlbName) {
            this.nlbName = nlbName;
        }

        @Override
        public final Builder nlbName(String nlbName) {
            this.nlbName = nlbName;
            return this;
        }

        public final String getProxyUrl() {
            return this.proxyUrl;
        }

        public final void setProxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
        }

        @Override
        public final Builder proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getVpcLinkId() {
            return this.vpcLinkId;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public ApiGatewayProxyConfig build() {
            return new ApiGatewayProxyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiGatewayProxyConfig> {
        public Builder apiGatewayId(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ApiGatewayEndpointType var1);

        public Builder nlbArn(String var1);

        public Builder nlbName(String var1);

        public Builder proxyUrl(String var1);

        public Builder stageName(String var1);

        public Builder vpcLinkId(String var1);
    }
}

