/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteRequest extends MigrationHubRefactorSpacesRequest implements
        ToCopyableBuilder<CreateRouteRequest.Builder, CreateRouteRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier").getter(getter(CreateRouteRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRouteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DefaultRouteInput> DEFAULT_ROUTE_FIELD = SdkField
            .<DefaultRouteInput> builder(MarshallingType.SDK_POJO).memberName("DefaultRoute")
            .getter(getter(CreateRouteRequest::defaultRoute)).setter(setter(Builder::defaultRoute))
            .constructor(DefaultRouteInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRoute").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentIdentifier").getter(getter(CreateRouteRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build())
            .build();

    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteType").getter(getter(CreateRouteRequest::routeTypeAsString)).setter(setter(Builder::routeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()).build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceIdentifier").getter(getter(CreateRouteRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIdentifier").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRouteRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UriPathRouteInput> URI_PATH_ROUTE_FIELD = SdkField
            .<UriPathRouteInput> builder(MarshallingType.SDK_POJO).memberName("UriPathRoute")
            .getter(getter(CreateRouteRequest::uriPathRoute)).setter(setter(Builder::uriPathRoute))
            .constructor(UriPathRouteInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPathRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD,
            CLIENT_TOKEN_FIELD, DEFAULT_ROUTE_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, ROUTE_TYPE_FIELD, SERVICE_IDENTIFIER_FIELD,
            TAGS_FIELD, URI_PATH_ROUTE_FIELD));

    private final String applicationIdentifier;

    private final String clientToken;

    private final DefaultRouteInput defaultRoute;

    private final String environmentIdentifier;

    private final String routeType;

    private final String serviceIdentifier;

    private final Map<String, String> tags;

    private final UriPathRouteInput uriPathRoute;

    private CreateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.clientToken = builder.clientToken;
        this.defaultRoute = builder.defaultRoute;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.routeType = builder.routeType;
        this.serviceIdentifier = builder.serviceIdentifier;
        this.tags = builder.tags;
        this.uriPathRoute = builder.uriPathRoute;
    }

    /**
     * <p>
     * The ID of the application within which the route is being created.
     * </p>
     * 
     * @return The ID of the application within which the route is being created.
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Configuration for the default route type.
     * </p>
     * 
     * @return Configuration for the default route type.
     */
    public final DefaultRouteInput defaultRoute() {
        return defaultRoute;
    }

    /**
     * <p>
     * The ID of the environment in which the route is created.
     * </p>
     * 
     * @return The ID of the environment in which the route is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is
     * forwarded to the default route. Applications must have a default route before any other routes can be created.
     * <code>URI_PATH</code> indicates a route that is based on a URI path.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another
     *         route is forwarded to the default route. Applications must have a default route before any other routes
     *         can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
     * @see RouteType
     */
    public final RouteType routeType() {
        return RouteType.fromValue(routeType);
    }

    /**
     * <p>
     * The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is
     * forwarded to the default route. Applications must have a default route before any other routes can be created.
     * <code>URI_PATH</code> indicates a route that is based on a URI path.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routeType} will
     * return {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routeTypeAsString}.
     * </p>
     * 
     * @return The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another
     *         route is forwarded to the default route. Applications must have a default route before any other routes
     *         can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
     * @see RouteType
     */
    public final String routeTypeAsString() {
        return routeType;
    }

    /**
     * <p>
     * The ID of the service in which the route is created. Traffic that matches this route is forwarded to this
     * service.
     * </p>
     * 
     * @return The ID of the service in which the route is created. Traffic that matches this route is forwarded to this
     *         service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key-value pair..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource.
     *         Each tag consists of a key-value pair..
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for the URI path route type.
     * </p>
     * 
     * @return The configuration for the URI path route type.
     */
    public final UriPathRouteInput uriPathRoute() {
        return uriPathRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uriPathRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest) obj;
        return Objects.equals(applicationIdentifier(), other.applicationIdentifier())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(defaultRoute(), other.defaultRoute())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(routeTypeAsString(), other.routeTypeAsString())
                && Objects.equals(serviceIdentifier(), other.serviceIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(uriPathRoute(), other.uriPathRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteRequest").add("ApplicationIdentifier", applicationIdentifier())
                .add("ClientToken", clientToken()).add("DefaultRoute", defaultRoute())
                .add("EnvironmentIdentifier", environmentIdentifier()).add("RouteType", routeTypeAsString())
                .add("ServiceIdentifier", serviceIdentifier())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("UriPathRoute", uriPathRoute())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DefaultRoute":
            return Optional.ofNullable(clazz.cast(defaultRoute()));
        case "EnvironmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "RouteType":
            return Optional.ofNullable(clazz.cast(routeTypeAsString()));
        case "ServiceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UriPathRoute":
            return Optional.ofNullable(clazz.cast(uriPathRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteRequest, T> g) {
        return obj -> g.apply((CreateRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRouteRequest> {
        /**
         * <p>
         * The ID of the application within which the route is being created.
         * </p>
         * 
         * @param applicationIdentifier
         *        The ID of the application within which the route is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Configuration for the default route type.
         * </p>
         * 
         * @param defaultRoute
         *        Configuration for the default route type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRoute(DefaultRouteInput defaultRoute);

        /**
         * <p>
         * Configuration for the default route type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultRouteInput.Builder} avoiding the
         * need to create one manually via {@link DefaultRouteInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultRouteInput.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultRoute(DefaultRouteInput)}.
         * 
         * @param defaultRoute
         *        a consumer that will call methods on {@link DefaultRouteInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRoute(DefaultRouteInput)
         */
        default Builder defaultRoute(Consumer<DefaultRouteInput.Builder> defaultRoute) {
            return defaultRoute(DefaultRouteInput.builder().applyMutation(defaultRoute).build());
        }

        /**
         * <p>
         * The ID of the environment in which the route is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment in which the route is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another
         * route is forwarded to the default route. Applications must have a default route before any other routes can
         * be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
         * </p>
         * 
         * @param routeType
         *        The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match
         *        another route is forwarded to the default route. Applications must have a default route before any
         *        other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(String routeType);

        /**
         * <p>
         * The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another
         * route is forwarded to the default route. Applications must have a default route before any other routes can
         * be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
         * </p>
         * 
         * @param routeType
         *        The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match
         *        another route is forwarded to the default route. Applications must have a default route before any
         *        other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder routeType(RouteType routeType);

        /**
         * <p>
         * The ID of the service in which the route is created. Traffic that matches this route is forwarded to this
         * service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID of the service in which the route is created. Traffic that matches this route is forwarded to
         *        this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        /**
         * <p>
         * The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each
         * tag consists of a key-value pair..
         * </p>
         * 
         * @param tags
         *        The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource.
         *        Each tag consists of a key-value pair..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for the URI path route type.
         * </p>
         * 
         * @param uriPathRoute
         *        The configuration for the URI path route type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPathRoute(UriPathRouteInput uriPathRoute);

        /**
         * <p>
         * The configuration for the URI path route type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UriPathRouteInput.Builder} avoiding the
         * need to create one manually via {@link UriPathRouteInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UriPathRouteInput.Builder#build()} is called immediately and its
         * result is passed to {@link #uriPathRoute(UriPathRouteInput)}.
         * 
         * @param uriPathRoute
         *        a consumer that will call methods on {@link UriPathRouteInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uriPathRoute(UriPathRouteInput)
         */
        default Builder uriPathRoute(Consumer<UriPathRouteInput.Builder> uriPathRoute) {
            return uriPathRoute(UriPathRouteInput.builder().applyMutation(uriPathRoute).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesRequest.BuilderImpl implements Builder {
        private String applicationIdentifier;

        private String clientToken;

        private DefaultRouteInput defaultRoute;

        private String environmentIdentifier;

        private String routeType;

        private String serviceIdentifier;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UriPathRouteInput uriPathRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteRequest model) {
            super(model);
            applicationIdentifier(model.applicationIdentifier);
            clientToken(model.clientToken);
            defaultRoute(model.defaultRoute);
            environmentIdentifier(model.environmentIdentifier);
            routeType(model.routeType);
            serviceIdentifier(model.serviceIdentifier);
            tags(model.tags);
            uriPathRoute(model.uriPathRoute);
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DefaultRouteInput.Builder getDefaultRoute() {
            return defaultRoute != null ? defaultRoute.toBuilder() : null;
        }

        public final void setDefaultRoute(DefaultRouteInput.BuilderImpl defaultRoute) {
            this.defaultRoute = defaultRoute != null ? defaultRoute.build() : null;
        }

        @Override
        public final Builder defaultRoute(DefaultRouteInput defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getRouteType() {
            return routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UriPathRouteInput.Builder getUriPathRoute() {
            return uriPathRoute != null ? uriPathRoute.toBuilder() : null;
        }

        public final void setUriPathRoute(UriPathRouteInput.BuilderImpl uriPathRoute) {
            this.uriPathRoute = uriPathRoute != null ? uriPathRoute.build() : null;
        }

        @Override
        public final Builder uriPathRoute(UriPathRouteInput uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteRequest build() {
            return new CreateRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
