/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummariesCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, ListServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServicesResponse.getter(ListServicesResponse::nextToken)).setter(ListServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServiceSummary>> SERVICE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceSummaryList").getter(ListServicesResponse.getter(ListServicesResponse::serviceSummaryList)).setter(ListServicesResponse.setter(Builder::serviceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_SUMMARY_LIST_FIELD));
    private final String nextToken;
    private final List<ServiceSummary> serviceSummaryList;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceSummaryList = builder.serviceSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServiceSummaryList() {
        return this.serviceSummaryList != null && !(this.serviceSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ServiceSummary> serviceSummaryList() {
        return this.serviceSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceSummaryList() ? this.serviceSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServiceSummaryList() == other.hasServiceSummaryList() && Objects.equals(this.serviceSummaryList(), other.serviceSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicesResponse").add("NextToken", (Object)this.nextToken()).add("ServiceSummaryList", this.hasServiceSummaryList() ? this.serviceSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServiceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.serviceSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceSummary> serviceSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceSummaryList(model.serviceSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceSummary.Builder> getServiceSummaryList() {
            List<ServiceSummary.Builder> result = ServiceSummariesCopier.copyToBuilder(this.serviceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceSummaryList(Collection<ServiceSummary.BuilderImpl> serviceSummaryList) {
            this.serviceSummaryList = ServiceSummariesCopier.copyFromBuilder(serviceSummaryList);
        }

        @Override
        public final Builder serviceSummaryList(Collection<ServiceSummary> serviceSummaryList) {
            this.serviceSummaryList = ServiceSummariesCopier.copy(serviceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaryList(ServiceSummary ... serviceSummaryList) {
            this.serviceSummaryList(Arrays.asList(serviceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaryList(Consumer<ServiceSummary.Builder> ... serviceSummaryList) {
            this.serviceSummaryList(Stream.of(serviceSummaryList).map(c -> (ServiceSummary)((ServiceSummary.Builder)ServiceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesResponse> {
        public Builder nextToken(String var1);

        public Builder serviceSummaryList(Collection<ServiceSummary> var1);

        public Builder serviceSummaryList(ServiceSummary ... var1);

        public Builder serviceSummaryList(Consumer<ServiceSummary.Builder> ... var1);
    }
}

