/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary;

public class ListWorkflowStepGroupsPublisher
implements SdkPublisher<ListWorkflowStepGroupsResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListWorkflowStepGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowStepGroupsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowStepGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowStepGroupsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowStepGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowStepGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowStepGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowStepGroupSummary> workflowStepGroupsSummary() {
        Function<ListWorkflowStepGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowStepGroupsSummary() != null) {
                return response.workflowStepGroupsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowStepGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowStepGroupsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowStepGroupsResponse> {
        private ListWorkflowStepGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowStepGroupsResponse> nextPage(ListWorkflowStepGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepGroupsPublisher.this.client.listWorkflowStepGroups(ListWorkflowStepGroupsPublisher.this.firstRequest);
            }
            return ListWorkflowStepGroupsPublisher.this.client.listWorkflowStepGroups((ListWorkflowStepGroupsRequest)((Object)ListWorkflowStepGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

