/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary;

public class ListTemplateStepGroupsPublisher
implements SdkPublisher<ListTemplateStepGroupsResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListTemplateStepGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateStepGroupsPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplateStepGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateStepGroupsPublisher(MigrationHubOrchestratorAsyncClient client, ListTemplateStepGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateStepGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateStepGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateStepGroupSummary> templateStepGroupSummary() {
        Function<ListTemplateStepGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateStepGroupSummary() != null) {
                return response.templateStepGroupSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTemplateStepGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTemplateStepGroupsResponseFetcher
    implements AsyncPageFetcher<ListTemplateStepGroupsResponse> {
        private ListTemplateStepGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateStepGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateStepGroupsResponse> nextPage(ListTemplateStepGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateStepGroupsPublisher.this.client.listTemplateStepGroups(ListTemplateStepGroupsPublisher.this.firstRequest);
            }
            return ListTemplateStepGroupsPublisher.this.client.listTemplateStepGroups((ListTemplateStepGroupsRequest)((Object)ListTemplateStepGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

