/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowStepRequest extends MigrationHubOrchestratorRequest implements
        ToCopyableBuilder<UpdateWorkflowStepRequest.Builder, UpdateWorkflowStepRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateWorkflowStepRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepGroupId").getter(getter(UpdateWorkflowStepRequest::stepGroupId))
            .setter(setter(Builder::stepGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(UpdateWorkflowStepRequest::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorkflowStepRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWorkflowStepRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepActionType").getter(getter(UpdateWorkflowStepRequest::stepActionTypeAsString))
            .setter(setter(Builder::stepActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()).build();

    private static final SdkField<WorkflowStepAutomationConfiguration> WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD = SdkField
            .<WorkflowStepAutomationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("workflowStepAutomationConfiguration")
            .getter(getter(UpdateWorkflowStepRequest::workflowStepAutomationConfiguration))
            .setter(setter(Builder::workflowStepAutomationConfiguration))
            .constructor(WorkflowStepAutomationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("workflowStepAutomationConfiguration").build()).build();

    private static final SdkField<List<String>> STEP_TARGET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stepTarget")
            .getter(getter(UpdateWorkflowStepRequest::stepTarget))
            .setter(setter(Builder::stepTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTarget").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkflowStepOutput>> OUTPUTS_FIELD = SdkField
            .<List<WorkflowStepOutput>> builder(MarshallingType.LIST)
            .memberName("outputs")
            .getter(getter(UpdateWorkflowStepRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowStepOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowStepOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(UpdateWorkflowStepRequest::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(UpdateWorkflowStepRequest::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateWorkflowStepRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STEP_GROUP_ID_FIELD,
            WORKFLOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STEP_ACTION_TYPE_FIELD,
            WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD, STEP_TARGET_FIELD, OUTPUTS_FIELD, PREVIOUS_FIELD, NEXT_FIELD,
            STATUS_FIELD));

    private final String id;

    private final String stepGroupId;

    private final String workflowId;

    private final String name;

    private final String description;

    private final String stepActionType;

    private final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;

    private final List<String> stepTarget;

    private final List<WorkflowStepOutput> outputs;

    private final List<String> previous;

    private final List<String> next;

    private final String status;

    private UpdateWorkflowStepRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.stepGroupId = builder.stepGroupId;
        this.workflowId = builder.workflowId;
        this.name = builder.name;
        this.description = builder.description;
        this.stepActionType = builder.stepActionType;
        this.workflowStepAutomationConfiguration = builder.workflowStepAutomationConfiguration;
        this.stepTarget = builder.stepTarget;
        this.outputs = builder.outputs;
        this.previous = builder.previous;
        this.next = builder.next;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the step.
     * </p>
     * 
     * @return The ID of the step.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the step group.
     * </p>
     * 
     * @return The ID of the step group.
     */
    public final String stepGroupId() {
        return stepGroupId;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the step.
     * </p>
     * 
     * @return The description of the step.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final StepActionType stepActionType() {
        return StepActionType.fromValue(stepActionType);
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final String stepActionTypeAsString() {
        return stepActionType;
    }

    /**
     * <p>
     * The custom script to run tests on the source and target environments.
     * </p>
     * 
     * @return The custom script to run tests on the source and target environments.
     */
    public final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration() {
        return workflowStepAutomationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepTarget property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStepTarget() {
        return stepTarget != null && !(stepTarget instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The servers on which a step will be run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepTarget} method.
     * </p>
     * 
     * @return The servers on which a step will be run.
     */
    public final List<String> stepTarget() {
        return stepTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs of a step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs of a step.
     */
    public final List<WorkflowStepOutput> outputs() {
        return outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step.
     */
    public final List<String> previous() {
        return previous;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step.
     */
    public final List<String> next() {
        return next;
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final StepStatus status() {
        return StepStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStepAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasStepTarget() ? stepTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowStepRequest)) {
            return false;
        }
        UpdateWorkflowStepRequest other = (UpdateWorkflowStepRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(stepGroupId(), other.stepGroupId())
                && Objects.equals(workflowId(), other.workflowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(stepActionTypeAsString(), other.stepActionTypeAsString())
                && Objects.equals(workflowStepAutomationConfiguration(), other.workflowStepAutomationConfiguration())
                && hasStepTarget() == other.hasStepTarget() && Objects.equals(stepTarget(), other.stepTarget())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && hasPrevious() == other.hasPrevious() && Objects.equals(previous(), other.previous())
                && hasNext() == other.hasNext() && Objects.equals(next(), other.next())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowStepRequest").add("Id", id()).add("StepGroupId", stepGroupId())
                .add("WorkflowId", workflowId()).add("Name", name()).add("Description", description())
                .add("StepActionType", stepActionTypeAsString())
                .add("WorkflowStepAutomationConfiguration", workflowStepAutomationConfiguration())
                .add("StepTarget", hasStepTarget() ? stepTarget() : null).add("Outputs", hasOutputs() ? outputs() : null)
                .add("Previous", hasPrevious() ? previous() : null).add("Next", hasNext() ? next() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "stepGroupId":
            return Optional.ofNullable(clazz.cast(stepGroupId()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stepActionType":
            return Optional.ofNullable(clazz.cast(stepActionTypeAsString()));
        case "workflowStepAutomationConfiguration":
            return Optional.ofNullable(clazz.cast(workflowStepAutomationConfiguration()));
        case "stepTarget":
            return Optional.ofNullable(clazz.cast(stepTarget()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowStepRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowStepRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkflowStepRequest> {
        /**
         * <p>
         * The ID of the step.
         * </p>
         * 
         * @param id
         *        The ID of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the step group.
         * </p>
         * 
         * @param stepGroupId
         *        The ID of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepGroupId(String stepGroupId);

        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param workflowId
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the step.
         * </p>
         * 
         * @param description
         *        The description of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(String stepActionType);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(StepActionType stepActionType);

        /**
         * <p>
         * The custom script to run tests on the source and target environments.
         * </p>
         * 
         * @param workflowStepAutomationConfiguration
         *        The custom script to run tests on the source and target environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration);

        /**
         * <p>
         * The custom script to run tests on the source and target environments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkflowStepAutomationConfiguration.Builder} avoiding the need to create one manually via
         * {@link WorkflowStepAutomationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowStepAutomationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration)}.
         * 
         * @param workflowStepAutomationConfiguration
         *        a consumer that will call methods on {@link WorkflowStepAutomationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration)
         */
        default Builder workflowStepAutomationConfiguration(
                Consumer<WorkflowStepAutomationConfiguration.Builder> workflowStepAutomationConfiguration) {
            return workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration.builder()
                    .applyMutation(workflowStepAutomationConfiguration).build());
        }

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTarget
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTarget(Collection<String> stepTarget);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTarget
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTarget(String... stepTarget);

        /**
         * <p>
         * The outputs of a step.
         * </p>
         * 
         * @param outputs
         *        The outputs of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<WorkflowStepOutput> outputs);

        /**
         * <p>
         * The outputs of a step.
         * </p>
         * 
         * @param outputs
         *        The outputs of a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(WorkflowStepOutput... outputs);

        /**
         * <p>
         * The outputs of a step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #outputs(List<WorkflowStepOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<WorkflowStepOutput>)
         */
        Builder outputs(Consumer<WorkflowStepOutput.Builder>... outputs);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(StepStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorRequest.BuilderImpl implements Builder {
        private String id;

        private String stepGroupId;

        private String workflowId;

        private String name;

        private String description;

        private String stepActionType;

        private WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;

        private List<String> stepTarget = DefaultSdkAutoConstructList.getInstance();

        private List<WorkflowStepOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowStepRequest model) {
            super(model);
            id(model.id);
            stepGroupId(model.stepGroupId);
            workflowId(model.workflowId);
            name(model.name);
            description(model.description);
            stepActionType(model.stepActionType);
            workflowStepAutomationConfiguration(model.workflowStepAutomationConfiguration);
            stepTarget(model.stepTarget);
            outputs(model.outputs);
            previous(model.previous);
            next(model.next);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStepGroupId() {
            return stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStepActionType() {
            return stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final WorkflowStepAutomationConfiguration.Builder getWorkflowStepAutomationConfiguration() {
            return workflowStepAutomationConfiguration != null ? workflowStepAutomationConfiguration.toBuilder() : null;
        }

        public final void setWorkflowStepAutomationConfiguration(
                WorkflowStepAutomationConfiguration.BuilderImpl workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration != null ? workflowStepAutomationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder workflowStepAutomationConfiguration(
                WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration;
            return this;
        }

        public final Collection<String> getStepTarget() {
            if (stepTarget instanceof SdkAutoConstructList) {
                return null;
            }
            return stepTarget;
        }

        public final void setStepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
        }

        @Override
        public final Builder stepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTarget(String... stepTarget) {
            stepTarget(Arrays.asList(stepTarget));
            return this;
        }

        public final List<WorkflowStepOutput.Builder> getOutputs() {
            List<WorkflowStepOutput.Builder> result = WorkflowStepOutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<WorkflowStepOutput.BuilderImpl> outputs) {
            this.outputs = WorkflowStepOutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<WorkflowStepOutput> outputs) {
            this.outputs = WorkflowStepOutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(WorkflowStepOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<WorkflowStepOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> WorkflowStepOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowStepRequest build() {
            return new UpdateWorkflowStepRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
