/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a migration workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrationWorkflowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MigrationWorkflowSummary.Builder, MigrationWorkflowSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MigrationWorkflowSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MigrationWorkflowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(MigrationWorkflowSummary::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("adsApplicationConfigurationName")
            .getter(getter(MigrationWorkflowSummary::adsApplicationConfigurationName))
            .setter(setter(Builder::adsApplicationConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationConfigurationName")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MigrationWorkflowSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(MigrationWorkflowSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(MigrationWorkflowSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(MigrationWorkflowSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Integer> COMPLETED_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("completedSteps").getter(getter(MigrationWorkflowSummary::completedSteps))
            .setter(setter(Builder::completedSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedSteps").build()).build();

    private static final SdkField<Integer> TOTAL_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalSteps").getter(getter(MigrationWorkflowSummary::totalSteps)).setter(setter(Builder::totalSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSteps").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD,
            STATUS_MESSAGE_FIELD, COMPLETED_STEPS_FIELD, TOTAL_STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String templateId;

    private final String adsApplicationConfigurationName;

    private final String status;

    private final Instant creationTime;

    private final Instant endTime;

    private final String statusMessage;

    private final Integer completedSteps;

    private final Integer totalSteps;

    private MigrationWorkflowSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationName = builder.adsApplicationConfigurationName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.statusMessage = builder.statusMessage;
        this.completedSteps = builder.completedSteps;
        this.totalSteps = builder.totalSteps;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the migration workflow.
     * </p>
     * 
     * @return The name of the migration workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the application configured in Application Discovery Service.
     * </p>
     * 
     * @return The name of the application configured in Application Discovery Service.
     */
    public final String adsApplicationConfigurationName() {
        return adsApplicationConfigurationName;
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the migration workflow was created.
     * </p>
     * 
     * @return The time at which the migration workflow was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the migration workflow ended.
     * </p>
     * 
     * @return The time at which the migration workflow ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status message of the migration workflow.
     * </p>
     * 
     * @return The status message of the migration workflow.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The steps completed in the migration workflow.
     * </p>
     * 
     * @return The steps completed in the migration workflow.
     */
    public final Integer completedSteps() {
        return completedSteps;
    }

    /**
     * <p>
     * All the steps in a migration workflow.
     * </p>
     * 
     * @return All the steps in a migration workflow.
     */
    public final Integer totalSteps() {
        return totalSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(adsApplicationConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(completedSteps());
        hashCode = 31 * hashCode + Objects.hashCode(totalSteps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationWorkflowSummary)) {
            return false;
        }
        MigrationWorkflowSummary other = (MigrationWorkflowSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(templateId(), other.templateId())
                && Objects.equals(adsApplicationConfigurationName(), other.adsApplicationConfigurationName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(completedSteps(), other.completedSteps()) && Objects.equals(totalSteps(), other.totalSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MigrationWorkflowSummary").add("Id", id()).add("Name", name()).add("TemplateId", templateId())
                .add("AdsApplicationConfigurationName", adsApplicationConfigurationName()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("EndTime", endTime()).add("StatusMessage", statusMessage())
                .add("CompletedSteps", completedSteps()).add("TotalSteps", totalSteps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "adsApplicationConfigurationName":
            return Optional.ofNullable(clazz.cast(adsApplicationConfigurationName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "completedSteps":
            return Optional.ofNullable(clazz.cast(completedSteps()));
        case "totalSteps":
            return Optional.ofNullable(clazz.cast(totalSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MigrationWorkflowSummary, T> g) {
        return obj -> g.apply((MigrationWorkflowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MigrationWorkflowSummary> {
        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param id
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the migration workflow.
         * </p>
         * 
         * @param name
         *        The name of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the application configured in Application Discovery Service.
         * </p>
         * 
         * @param adsApplicationConfigurationName
         *        The name of the application configured in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adsApplicationConfigurationName(String adsApplicationConfigurationName);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(MigrationWorkflowStatusEnum status);

        /**
         * <p>
         * The time at which the migration workflow was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the migration workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the migration workflow ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the migration workflow ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status message of the migration workflow.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The steps completed in the migration workflow.
         * </p>
         * 
         * @param completedSteps
         *        The steps completed in the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedSteps(Integer completedSteps);

        /**
         * <p>
         * All the steps in a migration workflow.
         * </p>
         * 
         * @param totalSteps
         *        All the steps in a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSteps(Integer totalSteps);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String templateId;

        private String adsApplicationConfigurationName;

        private String status;

        private Instant creationTime;

        private Instant endTime;

        private String statusMessage;

        private Integer completedSteps;

        private Integer totalSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationWorkflowSummary model) {
            id(model.id);
            name(model.name);
            templateId(model.templateId);
            adsApplicationConfigurationName(model.adsApplicationConfigurationName);
            status(model.status);
            creationTime(model.creationTime);
            endTime(model.endTime);
            statusMessage(model.statusMessage);
            completedSteps(model.completedSteps);
            totalSteps(model.totalSteps);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationName() {
            return adsApplicationConfigurationName;
        }

        public final void setAdsApplicationConfigurationName(String adsApplicationConfigurationName) {
            this.adsApplicationConfigurationName = adsApplicationConfigurationName;
        }

        @Override
        public final Builder adsApplicationConfigurationName(String adsApplicationConfigurationName) {
            this.adsApplicationConfigurationName = adsApplicationConfigurationName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getCompletedSteps() {
            return completedSteps;
        }

        public final void setCompletedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
        }

        @Override
        public final Builder completedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
            return this;
        }

        public final Integer getTotalSteps() {
            return totalSteps;
        }

        public final void setTotalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
        }

        @Override
        public final Builder totalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        @Override
        public MigrationWorkflowSummary build() {
            return new MigrationWorkflowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
