/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateStepResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<GetTemplateStepResponse.Builder, GetTemplateStepResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetTemplateStepResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepGroupId").getter(getter(GetTemplateStepResponse::stepGroupId)).setter(setter(Builder::stepGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(GetTemplateStepResponse::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTemplateStepResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTemplateStepResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepActionType").getter(getter(GetTemplateStepResponse::stepActionTypeAsString))
            .setter(setter(Builder::stepActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationTime").getter(getter(GetTemplateStepResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(GetTemplateStepResponse::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(GetTemplateStepResponse::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StepOutput>> OUTPUTS_FIELD = SdkField
            .<List<StepOutput>> builder(MarshallingType.LIST)
            .memberName("outputs")
            .getter(getter(GetTemplateStepResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StepAutomationConfiguration> STEP_AUTOMATION_CONFIGURATION_FIELD = SdkField
            .<StepAutomationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("stepAutomationConfiguration")
            .getter(getter(GetTemplateStepResponse::stepAutomationConfiguration))
            .setter(setter(Builder::stepAutomationConfiguration))
            .constructor(StepAutomationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepAutomationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STEP_GROUP_ID_FIELD,
            TEMPLATE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STEP_ACTION_TYPE_FIELD, CREATION_TIME_FIELD, PREVIOUS_FIELD,
            NEXT_FIELD, OUTPUTS_FIELD, STEP_AUTOMATION_CONFIGURATION_FIELD));

    private final String id;

    private final String stepGroupId;

    private final String templateId;

    private final String name;

    private final String description;

    private final String stepActionType;

    private final String creationTime;

    private final List<String> previous;

    private final List<String> next;

    private final List<StepOutput> outputs;

    private final StepAutomationConfiguration stepAutomationConfiguration;

    private GetTemplateStepResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.stepGroupId = builder.stepGroupId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.description = builder.description;
        this.stepActionType = builder.stepActionType;
        this.creationTime = builder.creationTime;
        this.previous = builder.previous;
        this.next = builder.next;
        this.outputs = builder.outputs;
        this.stepAutomationConfiguration = builder.stepAutomationConfiguration;
    }

    /**
     * <p>
     * The ID of the step.
     * </p>
     * 
     * @return The ID of the step.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the step group.
     * </p>
     * 
     * @return The ID of the step group.
     */
    public final String stepGroupId() {
        return stepGroupId;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the step.
     * </p>
     * 
     * @return The description of the step.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final StepActionType stepActionType() {
        return StepActionType.fromValue(stepActionType);
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final String stepActionTypeAsString() {
        return stepActionType;
    }

    /**
     * <p>
     * The time at which the step was created.
     * </p>
     * 
     * @return The time at which the step was created.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step.
     */
    public final List<String> previous() {
        return previous;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step.
     */
    public final List<String> next() {
        return next;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs of the step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs of the step.
     */
    public final List<StepOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The custom script to run tests on source or target environments.
     * </p>
     * 
     * @return The custom script to run tests on source or target environments.
     */
    public final StepAutomationConfiguration stepAutomationConfiguration() {
        return stepAutomationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stepAutomationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateStepResponse)) {
            return false;
        }
        GetTemplateStepResponse other = (GetTemplateStepResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(stepGroupId(), other.stepGroupId())
                && Objects.equals(templateId(), other.templateId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(stepActionTypeAsString(), other.stepActionTypeAsString())
                && Objects.equals(creationTime(), other.creationTime()) && hasPrevious() == other.hasPrevious()
                && Objects.equals(previous(), other.previous()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs())
                && Objects.equals(stepAutomationConfiguration(), other.stepAutomationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateStepResponse").add("Id", id()).add("StepGroupId", stepGroupId())
                .add("TemplateId", templateId()).add("Name", name()).add("Description", description())
                .add("StepActionType", stepActionTypeAsString()).add("CreationTime", creationTime())
                .add("Previous", hasPrevious() ? previous() : null).add("Next", hasNext() ? next() : null)
                .add("Outputs", hasOutputs() ? outputs() : null)
                .add("StepAutomationConfiguration", stepAutomationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "stepGroupId":
            return Optional.ofNullable(clazz.cast(stepGroupId()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stepActionType":
            return Optional.ofNullable(clazz.cast(stepActionTypeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "stepAutomationConfiguration":
            return Optional.ofNullable(clazz.cast(stepAutomationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateStepResponse, T> g) {
        return obj -> g.apply((GetTemplateStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemplateStepResponse> {
        /**
         * <p>
         * The ID of the step.
         * </p>
         * 
         * @param id
         *        The ID of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the step group.
         * </p>
         * 
         * @param stepGroupId
         *        The ID of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepGroupId(String stepGroupId);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the step.
         * </p>
         * 
         * @param description
         *        The description of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(String stepActionType);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(StepActionType stepActionType);

        /**
         * <p>
         * The time at which the step was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the step was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);

        /**
         * <p>
         * The outputs of the step.
         * </p>
         * 
         * @param outputs
         *        The outputs of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<StepOutput> outputs);

        /**
         * <p>
         * The outputs of the step.
         * </p>
         * 
         * @param outputs
         *        The outputs of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(StepOutput... outputs);

        /**
         * <p>
         * The outputs of the step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<StepOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<StepOutput>)
         */
        Builder outputs(Consumer<StepOutput.Builder>... outputs);

        /**
         * <p>
         * The custom script to run tests on source or target environments.
         * </p>
         * 
         * @param stepAutomationConfiguration
         *        The custom script to run tests on source or target environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAutomationConfiguration(StepAutomationConfiguration stepAutomationConfiguration);

        /**
         * <p>
         * The custom script to run tests on source or target environments.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepAutomationConfiguration.Builder}
         * avoiding the need to create one manually via {@link StepAutomationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepAutomationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #stepAutomationConfiguration(StepAutomationConfiguration)}.
         * 
         * @param stepAutomationConfiguration
         *        a consumer that will call methods on {@link StepAutomationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepAutomationConfiguration(StepAutomationConfiguration)
         */
        default Builder stepAutomationConfiguration(Consumer<StepAutomationConfiguration.Builder> stepAutomationConfiguration) {
            return stepAutomationConfiguration(StepAutomationConfiguration.builder().applyMutation(stepAutomationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String id;

        private String stepGroupId;

        private String templateId;

        private String name;

        private String description;

        private String stepActionType;

        private String creationTime;

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private List<StepOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private StepAutomationConfiguration stepAutomationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateStepResponse model) {
            super(model);
            id(model.id);
            stepGroupId(model.stepGroupId);
            templateId(model.templateId);
            name(model.name);
            description(model.description);
            stepActionType(model.stepActionType);
            creationTime(model.creationTime);
            previous(model.previous);
            next(model.next);
            outputs(model.outputs);
            stepAutomationConfiguration(model.stepAutomationConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStepGroupId() {
            return stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStepActionType() {
            return stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        public final List<StepOutput.Builder> getOutputs() {
            List<StepOutput.Builder> result = StepOutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<StepOutput.BuilderImpl> outputs) {
            this.outputs = StepOutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<StepOutput> outputs) {
            this.outputs = StepOutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(StepOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<StepOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> StepOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StepAutomationConfiguration.Builder getStepAutomationConfiguration() {
            return stepAutomationConfiguration != null ? stepAutomationConfiguration.toBuilder() : null;
        }

        public final void setStepAutomationConfiguration(StepAutomationConfiguration.BuilderImpl stepAutomationConfiguration) {
            this.stepAutomationConfiguration = stepAutomationConfiguration != null ? stepAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder stepAutomationConfiguration(StepAutomationConfiguration stepAutomationConfiguration) {
            this.stepAutomationConfiguration = stepAutomationConfiguration;
            return this;
        }

        @Override
        public GetTemplateStepResponse build() {
            return new GetTemplateStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
