/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StepActionType {
    MANUAL("MANUAL"),
    AUTOMATED("AUTOMATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StepActionType> VALUE_MAP;
    private final String value;

    private StepActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StepActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StepActionType> knownValues() {
        EnumSet<StepActionType> knownValues = EnumSet.allOf(StepActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StepActionType.class, StepActionType::toString);
    }
}

