/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplateStepGroupsResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, ListTemplateStepGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTemplateStepGroupsResponse.getter(ListTemplateStepGroupsResponse::nextToken)).setter(ListTemplateStepGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TemplateStepGroupSummary>> TEMPLATE_STEP_GROUP_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateStepGroupSummary").getter(ListTemplateStepGroupsResponse.getter(ListTemplateStepGroupsResponse::templateStepGroupSummary)).setter(ListTemplateStepGroupsResponse.setter(Builder::templateStepGroupSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateStepGroupSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateStepGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATE_STEP_GROUP_SUMMARY_FIELD));
    private final String nextToken;
    private final List<TemplateStepGroupSummary> templateStepGroupSummary;

    private ListTemplateStepGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateStepGroupSummary = builder.templateStepGroupSummary;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplateStepGroupSummary() {
        return this.templateStepGroupSummary != null && !(this.templateStepGroupSummary instanceof SdkAutoConstructList);
    }

    public final List<TemplateStepGroupSummary> templateStepGroupSummary() {
        return this.templateStepGroupSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateStepGroupSummary() ? this.templateStepGroupSummary() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateStepGroupsResponse)) {
            return false;
        }
        ListTemplateStepGroupsResponse other = (ListTemplateStepGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplateStepGroupSummary() == other.hasTemplateStepGroupSummary() && Objects.equals(this.templateStepGroupSummary(), other.templateStepGroupSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ListTemplateStepGroupsResponse").add("NextToken", (Object)this.nextToken()).add("TemplateStepGroupSummary", this.hasTemplateStepGroupSummary() ? this.templateStepGroupSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templateStepGroupSummary": {
                return Optional.ofNullable(clazz.cast(this.templateStepGroupSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateStepGroupsResponse, T> g) {
        return obj -> g.apply((ListTemplateStepGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TemplateStepGroupSummary> templateStepGroupSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateStepGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templateStepGroupSummary(model.templateStepGroupSummary);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TemplateStepGroupSummary.Builder> getTemplateStepGroupSummary() {
            List<TemplateStepGroupSummary.Builder> result = TemplateStepGroupSummaryListCopier.copyToBuilder(this.templateStepGroupSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateStepGroupSummary(Collection<TemplateStepGroupSummary.BuilderImpl> templateStepGroupSummary) {
            this.templateStepGroupSummary = TemplateStepGroupSummaryListCopier.copyFromBuilder(templateStepGroupSummary);
        }

        @Override
        public final Builder templateStepGroupSummary(Collection<TemplateStepGroupSummary> templateStepGroupSummary) {
            this.templateStepGroupSummary = TemplateStepGroupSummaryListCopier.copy(templateStepGroupSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepGroupSummary(TemplateStepGroupSummary ... templateStepGroupSummary) {
            this.templateStepGroupSummary(Arrays.asList(templateStepGroupSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepGroupSummary(Consumer<TemplateStepGroupSummary.Builder> ... templateStepGroupSummary) {
            this.templateStepGroupSummary(Stream.of(templateStepGroupSummary).map(c -> (TemplateStepGroupSummary)((TemplateStepGroupSummary.Builder)TemplateStepGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTemplateStepGroupsResponse build() {
            return new ListTemplateStepGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplateStepGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder templateStepGroupSummary(Collection<TemplateStepGroupSummary> var1);

        public Builder templateStepGroupSummary(TemplateStepGroupSummary ... var1);

        public Builder templateStepGroupSummary(Consumer<TemplateStepGroupSummary.Builder> ... var1);
    }
}

