/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorSsmCommandConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorSsmCommandConfig> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudWatchLogGroupName").getter(ConnectorSsmCommandConfig.getter(ConnectorSsmCommandConfig::cloudWatchLogGroupName)).setter(ConnectorSsmCommandConfig.setter(Builder::cloudWatchLogGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_OUTPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cloudWatchOutputEnabled").getter(ConnectorSsmCommandConfig.getter(ConnectorSsmCommandConfig::cloudWatchOutputEnabled)).setter(ConnectorSsmCommandConfig.setter(Builder::cloudWatchOutputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchOutputEnabled").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3BucketName").getter(ConnectorSsmCommandConfig.getter(ConnectorSsmCommandConfig::outputS3BucketName)).setter(ConnectorSsmCommandConfig.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3BucketName").build()}).build();
    private static final SdkField<Boolean> S3_OUTPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("s3OutputEnabled").getter(ConnectorSsmCommandConfig.getter(ConnectorSsmCommandConfig::s3OutputEnabled)).setter(ConnectorSsmCommandConfig.setter(Builder::s3OutputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_OUTPUT_ENABLED_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, S3_OUTPUT_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLogGroupName;
    private final Boolean cloudWatchOutputEnabled;
    private final String outputS3BucketName;
    private final Boolean s3OutputEnabled;

    private ConnectorSsmCommandConfig(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchOutputEnabled = builder.cloudWatchOutputEnabled;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.s3OutputEnabled = builder.s3OutputEnabled;
    }

    public final String cloudWatchLogGroupName() {
        return this.cloudWatchLogGroupName;
    }

    public final Boolean cloudWatchOutputEnabled() {
        return this.cloudWatchOutputEnabled;
    }

    public final String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public final Boolean s3OutputEnabled() {
        return this.s3OutputEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSsmCommandConfig)) {
            return false;
        }
        ConnectorSsmCommandConfig other = (ConnectorSsmCommandConfig)obj;
        return Objects.equals(this.cloudWatchLogGroupName(), other.cloudWatchLogGroupName()) && Objects.equals(this.cloudWatchOutputEnabled(), other.cloudWatchOutputEnabled()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.s3OutputEnabled(), other.s3OutputEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorSsmCommandConfig").add("CloudWatchLogGroupName", (Object)this.cloudWatchLogGroupName()).add("CloudWatchOutputEnabled", (Object)this.cloudWatchOutputEnabled()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("S3OutputEnabled", (Object)this.s3OutputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogGroupName": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupName()));
            }
            case "cloudWatchOutputEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputEnabled()));
            }
            case "outputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "s3OutputEnabled": {
                return Optional.ofNullable(clazz.cast(this.s3OutputEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSsmCommandConfig, T> g) {
        return obj -> g.apply((ConnectorSsmCommandConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogGroupName;
        private Boolean cloudWatchOutputEnabled;
        private String outputS3BucketName;
        private Boolean s3OutputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSsmCommandConfig model) {
            this.cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            this.cloudWatchOutputEnabled(model.cloudWatchOutputEnabled);
            this.outputS3BucketName(model.outputS3BucketName);
            this.s3OutputEnabled(model.s3OutputEnabled);
        }

        public final String getCloudWatchLogGroupName() {
            return this.cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final Boolean getCloudWatchOutputEnabled() {
            return this.cloudWatchOutputEnabled;
        }

        public final void setCloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
        }

        @Override
        public final Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
            return this;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final Boolean getS3OutputEnabled() {
            return this.s3OutputEnabled;
        }

        public final void setS3OutputEnabled(Boolean s3OutputEnabled) {
            this.s3OutputEnabled = s3OutputEnabled;
        }

        @Override
        public final Builder s3OutputEnabled(Boolean s3OutputEnabled) {
            this.s3OutputEnabled = s3OutputEnabled;
            return this;
        }

        public ConnectorSsmCommandConfig build() {
            return new ConnectorSsmCommandConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorSsmCommandConfig> {
        public Builder cloudWatchLogGroupName(String var1);

        public Builder cloudWatchOutputEnabled(Boolean var1);

        public Builder outputS3BucketName(String var1);

        public Builder s3OutputEnabled(Boolean var1);
    }
}

