/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connector SSM command config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorSsmCommandConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorSsmCommandConfig.Builder, ConnectorSsmCommandConfig> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogGroupName").getter(getter(ConnectorSsmCommandConfig::cloudWatchLogGroupName))
            .setter(setter(Builder::cloudWatchLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build())
            .build();

    private static final SdkField<Boolean> CLOUD_WATCH_OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cloudWatchOutputEnabled").getter(getter(ConnectorSsmCommandConfig::cloudWatchOutputEnabled))
            .setter(setter(Builder::cloudWatchOutputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchOutputEnabled").build())
            .build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3BucketName").getter(getter(ConnectorSsmCommandConfig::outputS3BucketName))
            .setter(setter(Builder::outputS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3BucketName").build())
            .build();

    private static final SdkField<Boolean> S3_OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("s3OutputEnabled").getter(getter(ConnectorSsmCommandConfig::s3OutputEnabled))
            .setter(setter(Builder::s3OutputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_OUTPUT_ENABLED_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD,
            S3_OUTPUT_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupName;

    private final Boolean cloudWatchOutputEnabled;

    private final String outputS3BucketName;

    private final Boolean s3OutputEnabled;

    private ConnectorSsmCommandConfig(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchOutputEnabled = builder.cloudWatchOutputEnabled;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.s3OutputEnabled = builder.s3OutputEnabled;
    }

    /**
     * <p>
     * Connector SSM command config CloudWatch log group name.
     * </p>
     * 
     * @return Connector SSM command config CloudWatch log group name.
     */
    public final String cloudWatchLogGroupName() {
        return cloudWatchLogGroupName;
    }

    /**
     * <p>
     * Connector SSM command config CloudWatch output enabled.
     * </p>
     * 
     * @return Connector SSM command config CloudWatch output enabled.
     */
    public final Boolean cloudWatchOutputEnabled() {
        return cloudWatchOutputEnabled;
    }

    /**
     * <p>
     * Connector SSM command config output S3 bucket name.
     * </p>
     * 
     * @return Connector SSM command config output S3 bucket name.
     */
    public final String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * Connector SSM command config S3 output enabled.
     * </p>
     * 
     * @return Connector SSM command config S3 output enabled.
     */
    public final Boolean s3OutputEnabled() {
        return s3OutputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchOutputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSsmCommandConfig)) {
            return false;
        }
        ConnectorSsmCommandConfig other = (ConnectorSsmCommandConfig) obj;
        return Objects.equals(cloudWatchLogGroupName(), other.cloudWatchLogGroupName())
                && Objects.equals(cloudWatchOutputEnabled(), other.cloudWatchOutputEnabled())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName())
                && Objects.equals(s3OutputEnabled(), other.s3OutputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorSsmCommandConfig").add("CloudWatchLogGroupName", cloudWatchLogGroupName())
                .add("CloudWatchOutputEnabled", cloudWatchOutputEnabled()).add("OutputS3BucketName", outputS3BucketName())
                .add("S3OutputEnabled", s3OutputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogGroupName":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupName()));
        case "cloudWatchOutputEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchOutputEnabled()));
        case "outputS3BucketName":
            return Optional.ofNullable(clazz.cast(outputS3BucketName()));
        case "s3OutputEnabled":
            return Optional.ofNullable(clazz.cast(s3OutputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSsmCommandConfig, T> g) {
        return obj -> g.apply((ConnectorSsmCommandConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorSsmCommandConfig> {
        /**
         * <p>
         * Connector SSM command config CloudWatch log group name.
         * </p>
         * 
         * @param cloudWatchLogGroupName
         *        Connector SSM command config CloudWatch log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupName(String cloudWatchLogGroupName);

        /**
         * <p>
         * Connector SSM command config CloudWatch output enabled.
         * </p>
         * 
         * @param cloudWatchOutputEnabled
         *        Connector SSM command config CloudWatch output enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled);

        /**
         * <p>
         * Connector SSM command config output S3 bucket name.
         * </p>
         * 
         * @param outputS3BucketName
         *        Connector SSM command config output S3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * Connector SSM command config S3 output enabled.
         * </p>
         * 
         * @param s3OutputEnabled
         *        Connector SSM command config S3 output enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputEnabled(Boolean s3OutputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupName;

        private Boolean cloudWatchOutputEnabled;

        private String outputS3BucketName;

        private Boolean s3OutputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSsmCommandConfig model) {
            cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            cloudWatchOutputEnabled(model.cloudWatchOutputEnabled);
            outputS3BucketName(model.outputS3BucketName);
            s3OutputEnabled(model.s3OutputEnabled);
        }

        public final String getCloudWatchLogGroupName() {
            return cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final Boolean getCloudWatchOutputEnabled() {
            return cloudWatchOutputEnabled;
        }

        public final void setCloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
        }

        @Override
        public final Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
            return this;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final Boolean getS3OutputEnabled() {
            return s3OutputEnabled;
        }

        public final void setS3OutputEnabled(Boolean s3OutputEnabled) {
            this.s3OutputEnabled = s3OutputEnabled;
        }

        @Override
        public final Builder s3OutputEnabled(Boolean s3OutputEnabled) {
            this.s3OutputEnabled = s3OutputEnabled;
            return this;
        }

        @Override
        public ConnectorSsmCommandConfig build() {
            return new ConnectorSsmCommandConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
