/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.ExportErrorData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTaskError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTaskError> {
    private static final SdkField<ExportErrorData> ERROR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorData").getter(ExportTaskError.getter(ExportTaskError::errorData)).setter(ExportTaskError.setter(Builder::errorData)).constructor(ExportErrorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorData").build()}).build();
    private static final SdkField<String> ERROR_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorDateTime").getter(ExportTaskError.getter(ExportTaskError::errorDateTime)).setter(ExportTaskError.setter(Builder::errorDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_DATA_FIELD, ERROR_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ExportErrorData errorData;
    private final String errorDateTime;

    private ExportTaskError(BuilderImpl builder) {
        this.errorData = builder.errorData;
        this.errorDateTime = builder.errorDateTime;
    }

    public final ExportErrorData errorData() {
        return this.errorData;
    }

    public final String errorDateTime() {
        return this.errorDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorData());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskError)) {
            return false;
        }
        ExportTaskError other = (ExportTaskError)obj;
        return Objects.equals(this.errorData(), other.errorData()) && Objects.equals(this.errorDateTime(), other.errorDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTaskError").add("ErrorData", (Object)this.errorData()).add("ErrorDateTime", (Object)this.errorDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorData": {
                return Optional.ofNullable(clazz.cast(this.errorData()));
            }
            case "errorDateTime": {
                return Optional.ofNullable(clazz.cast(this.errorDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTaskError, T> g) {
        return obj -> g.apply((ExportTaskError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExportErrorData errorData;
        private String errorDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskError model) {
            this.errorData(model.errorData);
            this.errorDateTime(model.errorDateTime);
        }

        public final ExportErrorData.Builder getErrorData() {
            return this.errorData != null ? this.errorData.toBuilder() : null;
        }

        public final void setErrorData(ExportErrorData.BuilderImpl errorData) {
            this.errorData = errorData != null ? errorData.build() : null;
        }

        @Override
        public final Builder errorData(ExportErrorData errorData) {
            this.errorData = errorData;
            return this;
        }

        public final String getErrorDateTime() {
            return this.errorDateTime;
        }

        public final void setErrorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
        }

        @Override
        public final Builder errorDateTime(String errorDateTime) {
            this.errorDateTime = errorDateTime;
            return this;
        }

        public ExportTaskError build() {
            return new ExportTaskError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTaskError> {
        public Builder errorData(ExportErrorData var1);

        default public Builder errorData(Consumer<ExportErrorData.Builder> errorData) {
            return this.errorData((ExportErrorData)((ExportErrorData.Builder)ExportErrorData.builder().applyMutation(errorData)).build());
        }

        public Builder errorDateTime(String var1);
    }
}

