/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import task summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTaskSummary.Builder, ImportTaskSummary> {
    private static final SdkField<ImportTaskSummaryApplications> APPLICATIONS_FIELD = SdkField
            .<ImportTaskSummaryApplications> builder(MarshallingType.SDK_POJO).memberName("applications")
            .getter(getter(ImportTaskSummary::applications)).setter(setter(Builder::applications))
            .constructor(ImportTaskSummaryApplications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applications").build()).build();

    private static final SdkField<ImportTaskSummaryServers> SERVERS_FIELD = SdkField
            .<ImportTaskSummaryServers> builder(MarshallingType.SDK_POJO).memberName("servers")
            .getter(getter(ImportTaskSummary::servers)).setter(setter(Builder::servers))
            .constructor(ImportTaskSummaryServers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()).build();

    private static final SdkField<ImportTaskSummaryWaves> WAVES_FIELD = SdkField
            .<ImportTaskSummaryWaves> builder(MarshallingType.SDK_POJO).memberName("waves")
            .getter(getter(ImportTaskSummary::waves)).setter(setter(Builder::waves)).constructor(ImportTaskSummaryWaves::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waves").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_FIELD,
            SERVERS_FIELD, WAVES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImportTaskSummaryApplications applications;

    private final ImportTaskSummaryServers servers;

    private final ImportTaskSummaryWaves waves;

    private ImportTaskSummary(BuilderImpl builder) {
        this.applications = builder.applications;
        this.servers = builder.servers;
        this.waves = builder.waves;
    }

    /**
     * <p>
     * Import task summary applications.
     * </p>
     * 
     * @return Import task summary applications.
     */
    public final ImportTaskSummaryApplications applications() {
        return applications;
    }

    /**
     * <p>
     * Import task summary servers.
     * </p>
     * 
     * @return Import task summary servers.
     */
    public final ImportTaskSummaryServers servers() {
        return servers;
    }

    /**
     * <p>
     * Import task summary waves.
     * </p>
     * 
     * @return Import task summary waves.
     */
    public final ImportTaskSummaryWaves waves() {
        return waves;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        hashCode = 31 * hashCode + Objects.hashCode(servers());
        hashCode = 31 * hashCode + Objects.hashCode(waves());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTaskSummary)) {
            return false;
        }
        ImportTaskSummary other = (ImportTaskSummary) obj;
        return Objects.equals(applications(), other.applications()) && Objects.equals(servers(), other.servers())
                && Objects.equals(waves(), other.waves());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTaskSummary").add("Applications", applications()).add("Servers", servers())
                .add("Waves", waves()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "servers":
            return Optional.ofNullable(clazz.cast(servers()));
        case "waves":
            return Optional.ofNullable(clazz.cast(waves()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTaskSummary, T> g) {
        return obj -> g.apply((ImportTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTaskSummary> {
        /**
         * <p>
         * Import task summary applications.
         * </p>
         * 
         * @param applications
         *        Import task summary applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(ImportTaskSummaryApplications applications);

        /**
         * <p>
         * Import task summary applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTaskSummaryApplications.Builder}
         * avoiding the need to create one manually via {@link ImportTaskSummaryApplications#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTaskSummaryApplications.Builder#build()} is called
         * immediately and its result is passed to {@link #applications(ImportTaskSummaryApplications)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link ImportTaskSummaryApplications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(ImportTaskSummaryApplications)
         */
        default Builder applications(Consumer<ImportTaskSummaryApplications.Builder> applications) {
            return applications(ImportTaskSummaryApplications.builder().applyMutation(applications).build());
        }

        /**
         * <p>
         * Import task summary servers.
         * </p>
         * 
         * @param servers
         *        Import task summary servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(ImportTaskSummaryServers servers);

        /**
         * <p>
         * Import task summary servers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTaskSummaryServers.Builder}
         * avoiding the need to create one manually via {@link ImportTaskSummaryServers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTaskSummaryServers.Builder#build()} is called immediately
         * and its result is passed to {@link #servers(ImportTaskSummaryServers)}.
         * 
         * @param servers
         *        a consumer that will call methods on {@link ImportTaskSummaryServers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servers(ImportTaskSummaryServers)
         */
        default Builder servers(Consumer<ImportTaskSummaryServers.Builder> servers) {
            return servers(ImportTaskSummaryServers.builder().applyMutation(servers).build());
        }

        /**
         * <p>
         * Import task summary waves.
         * </p>
         * 
         * @param waves
         *        Import task summary waves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waves(ImportTaskSummaryWaves waves);

        /**
         * <p>
         * Import task summary waves.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTaskSummaryWaves.Builder} avoiding
         * the need to create one manually via {@link ImportTaskSummaryWaves#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTaskSummaryWaves.Builder#build()} is called immediately and
         * its result is passed to {@link #waves(ImportTaskSummaryWaves)}.
         * 
         * @param waves
         *        a consumer that will call methods on {@link ImportTaskSummaryWaves.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waves(ImportTaskSummaryWaves)
         */
        default Builder waves(Consumer<ImportTaskSummaryWaves.Builder> waves) {
            return waves(ImportTaskSummaryWaves.builder().applyMutation(waves).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImportTaskSummaryApplications applications;

        private ImportTaskSummaryServers servers;

        private ImportTaskSummaryWaves waves;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTaskSummary model) {
            applications(model.applications);
            servers(model.servers);
            waves(model.waves);
        }

        public final ImportTaskSummaryApplications.Builder getApplications() {
            return applications != null ? applications.toBuilder() : null;
        }

        public final void setApplications(ImportTaskSummaryApplications.BuilderImpl applications) {
            this.applications = applications != null ? applications.build() : null;
        }

        @Override
        public final Builder applications(ImportTaskSummaryApplications applications) {
            this.applications = applications;
            return this;
        }

        public final ImportTaskSummaryServers.Builder getServers() {
            return servers != null ? servers.toBuilder() : null;
        }

        public final void setServers(ImportTaskSummaryServers.BuilderImpl servers) {
            this.servers = servers != null ? servers.build() : null;
        }

        @Override
        public final Builder servers(ImportTaskSummaryServers servers) {
            this.servers = servers;
            return this;
        }

        public final ImportTaskSummaryWaves.Builder getWaves() {
            return waves != null ? waves.toBuilder() : null;
        }

        public final void setWaves(ImportTaskSummaryWaves.BuilderImpl waves) {
            this.waves = waves != null ? waves.build() : null;
        }

        @Override
        public final Builder waves(ImportTaskSummaryWaves waves) {
            this.waves = waves;
            return this;
        }

        @Override
        public ImportTaskSummary build() {
            return new ImportTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
