/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTask implements SdkPojo, Serializable, ToCopyableBuilder<ImportTask.Builder, ImportTask> {
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationDateTime").getter(getter(ImportTask::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDateTime").getter(getter(ImportTask::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importID").getter(getter(ImportTask::importID)).setter(setter(Builder::importID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importID").build()).build();

    private static final SdkField<Float> PROGRESS_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("progressPercentage").getter(getter(ImportTask::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build())
            .build();

    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField
            .<S3BucketSource> builder(MarshallingType.SDK_POJO).memberName("s3BucketSource")
            .getter(getter(ImportTask::s3BucketSource)).setter(setter(Builder::s3BucketSource))
            .constructor(S3BucketSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketSource").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ImportTaskSummary> SUMMARY_FIELD = SdkField
            .<ImportTaskSummary> builder(MarshallingType.SDK_POJO).memberName("summary").getter(getter(ImportTask::summary))
            .setter(setter(Builder::summary)).constructor(ImportTaskSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD, END_DATE_TIME_FIELD, IMPORT_ID_FIELD,
                    PROGRESS_PERCENTAGE_FIELD, S3_BUCKET_SOURCE_FIELD, STATUS_FIELD, SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creationDateTime;

    private final String endDateTime;

    private final String importID;

    private final Float progressPercentage;

    private final S3BucketSource s3BucketSource;

    private final String status;

    private final ImportTaskSummary summary;

    private ImportTask(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.importID = builder.importID;
        this.progressPercentage = builder.progressPercentage;
        this.s3BucketSource = builder.s3BucketSource;
        this.status = builder.status;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * Import task creation datetime.
     * </p>
     * 
     * @return Import task creation datetime.
     */
    public final String creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * Import task end datetime.
     * </p>
     * 
     * @return Import task end datetime.
     */
    public final String endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * Import task id.
     * </p>
     * 
     * @return Import task id.
     */
    public final String importID() {
        return importID;
    }

    /**
     * <p>
     * Import task progress percentage.
     * </p>
     * 
     * @return Import task progress percentage.
     */
    public final Float progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * Import task s3 bucket source.
     * </p>
     * 
     * @return Import task s3 bucket source.
     */
    public final S3BucketSource s3BucketSource() {
        return s3BucketSource;
    }

    /**
     * <p>
     * Import task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Import task status.
     * @see ImportStatus
     */
    public final ImportStatus status() {
        return ImportStatus.fromValue(status);
    }

    /**
     * <p>
     * Import task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Import task status.
     * @see ImportStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Import task summary.
     * </p>
     * 
     * @return Import task summary.
     */
    public final ImportTaskSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(importID());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTask)) {
            return false;
        }
        ImportTask other = (ImportTask) obj;
        return Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(endDateTime(), other.endDateTime())
                && Objects.equals(importID(), other.importID())
                && Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(s3BucketSource(), other.s3BucketSource())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTask").add("CreationDateTime", creationDateTime()).add("EndDateTime", endDateTime())
                .add("ImportID", importID()).add("ProgressPercentage", progressPercentage())
                .add("S3BucketSource", s3BucketSource()).add("Status", statusAsString()).add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "importID":
            return Optional.ofNullable(clazz.cast(importID()));
        case "progressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "s3BucketSource":
            return Optional.ofNullable(clazz.cast(s3BucketSource()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTask, T> g) {
        return obj -> g.apply((ImportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTask> {
        /**
         * <p>
         * Import task creation datetime.
         * </p>
         * 
         * @param creationDateTime
         *        Import task creation datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(String creationDateTime);

        /**
         * <p>
         * Import task end datetime.
         * </p>
         * 
         * @param endDateTime
         *        Import task end datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);

        /**
         * <p>
         * Import task id.
         * </p>
         * 
         * @param importID
         *        Import task id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importID(String importID);

        /**
         * <p>
         * Import task progress percentage.
         * </p>
         * 
         * @param progressPercentage
         *        Import task progress percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Float progressPercentage);

        /**
         * <p>
         * Import task s3 bucket source.
         * </p>
         * 
         * @param s3BucketSource
         *        Import task s3 bucket source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketSource(S3BucketSource s3BucketSource);

        /**
         * <p>
         * Import task s3 bucket source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketSource.Builder} avoiding the need
         * to create one manually via {@link S3BucketSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3BucketSource(S3BucketSource)}.
         * 
         * @param s3BucketSource
         *        a consumer that will call methods on {@link S3BucketSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketSource(S3BucketSource)
         */
        default Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return s3BucketSource(S3BucketSource.builder().applyMutation(s3BucketSource).build());
        }

        /**
         * <p>
         * Import task status.
         * </p>
         * 
         * @param status
         *        Import task status.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Import task status.
         * </p>
         * 
         * @param status
         *        Import task status.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder status(ImportStatus status);

        /**
         * <p>
         * Import task summary.
         * </p>
         * 
         * @param summary
         *        Import task summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(ImportTaskSummary summary);

        /**
         * <p>
         * Import task summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTaskSummary.Builder} avoiding the
         * need to create one manually via {@link ImportTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTaskSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(ImportTaskSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link ImportTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(ImportTaskSummary)
         */
        default Builder summary(Consumer<ImportTaskSummary.Builder> summary) {
            return summary(ImportTaskSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String creationDateTime;

        private String endDateTime;

        private String importID;

        private Float progressPercentage;

        private S3BucketSource s3BucketSource;

        private String status;

        private ImportTaskSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTask model) {
            creationDateTime(model.creationDateTime);
            endDateTime(model.endDateTime);
            importID(model.importID);
            progressPercentage(model.progressPercentage);
            s3BucketSource(model.s3BucketSource);
            status(model.status);
            summary(model.summary);
        }

        public final String getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getImportID() {
            return importID;
        }

        public final void setImportID(String importID) {
            this.importID = importID;
        }

        @Override
        public final Builder importID(String importID) {
            this.importID = importID;
            return this;
        }

        public final Float getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return s3BucketSource != null ? s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ImportTaskSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(ImportTaskSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(ImportTaskSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ImportTask build() {
            return new ImportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
