/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageSetMetadataRequest extends MedicalImagingRequest implements
        ToCopyableBuilder<UpdateImageSetMetadataRequest.Builder, UpdateImageSetMetadataRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(UpdateImageSetMetadataRequest::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()).build();

    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(UpdateImageSetMetadataRequest::imageSetId))
            .setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("imageSetId").build()).build();

    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersionId").getter(getter(UpdateImageSetMetadataRequest::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("latestVersion").build()).build();

    private static final SdkField<MetadataUpdates> UPDATE_IMAGE_SET_METADATA_UPDATES_FIELD = SdkField
            .<MetadataUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("updateImageSetMetadataUpdates")
            .getter(getter(UpdateImageSetMetadataRequest::updateImageSetMetadataUpdates))
            .setter(setter(Builder::updateImageSetMetadataUpdates))
            .constructor(MetadataUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateImageSetMetadataUpdates")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            IMAGE_SET_ID_FIELD, LATEST_VERSION_ID_FIELD, UPDATE_IMAGE_SET_METADATA_UPDATES_FIELD));

    private final String datastoreId;

    private final String imageSetId;

    private final String latestVersionId;

    private final MetadataUpdates updateImageSetMetadataUpdates;

    private UpdateImageSetMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.updateImageSetMetadataUpdates = builder.updateImageSetMetadataUpdates;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The latest image set version identifier.
     * </p>
     * 
     * @return The latest image set version identifier.
     */
    public final String latestVersionId() {
        return latestVersionId;
    }

    /**
     * <p>
     * Update image set metadata updates.
     * </p>
     * 
     * @return Update image set metadata updates.
     */
    public final MetadataUpdates updateImageSetMetadataUpdates() {
        return updateImageSetMetadataUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(updateImageSetMetadataUpdates());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageSetMetadataRequest)) {
            return false;
        }
        UpdateImageSetMetadataRequest other = (UpdateImageSetMetadataRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(imageSetId(), other.imageSetId())
                && Objects.equals(latestVersionId(), other.latestVersionId())
                && Objects.equals(updateImageSetMetadataUpdates(), other.updateImageSetMetadataUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageSetMetadataRequest").add("DatastoreId", datastoreId())
                .add("ImageSetId", imageSetId()).add("LatestVersionId", latestVersionId())
                .add("UpdateImageSetMetadataUpdates", updateImageSetMetadataUpdates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "latestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        case "updateImageSetMetadataUpdates":
            return Optional.ofNullable(clazz.cast(updateImageSetMetadataUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageSetMetadataRequest, T> g) {
        return obj -> g.apply((UpdateImageSetMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateImageSetMetadataRequest> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The latest image set version identifier.
         * </p>
         * 
         * @param latestVersionId
         *        The latest image set version identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(String latestVersionId);

        /**
         * <p>
         * Update image set metadata updates.
         * </p>
         * 
         * @param updateImageSetMetadataUpdates
         *        Update image set metadata updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateImageSetMetadataUpdates(MetadataUpdates updateImageSetMetadataUpdates);

        /**
         * <p>
         * Update image set metadata updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataUpdates.Builder} avoiding the
         * need to create one manually via {@link MetadataUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataUpdates.Builder#build()} is called immediately and its
         * result is passed to {@link #updateImageSetMetadataUpdates(MetadataUpdates)}.
         * 
         * @param updateImageSetMetadataUpdates
         *        a consumer that will call methods on {@link MetadataUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateImageSetMetadataUpdates(MetadataUpdates)
         */
        default Builder updateImageSetMetadataUpdates(Consumer<MetadataUpdates.Builder> updateImageSetMetadataUpdates) {
            return updateImageSetMetadataUpdates(MetadataUpdates.builder().applyMutation(updateImageSetMetadataUpdates).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MedicalImagingRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private String imageSetId;

        private String latestVersionId;

        private MetadataUpdates updateImageSetMetadataUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageSetMetadataRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            imageSetId(model.imageSetId);
            latestVersionId(model.latestVersionId);
            updateImageSetMetadataUpdates(model.updateImageSetMetadataUpdates);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final MetadataUpdates.Builder getUpdateImageSetMetadataUpdates() {
            return updateImageSetMetadataUpdates != null ? updateImageSetMetadataUpdates.toBuilder() : null;
        }

        public final void setUpdateImageSetMetadataUpdates(MetadataUpdates.BuilderImpl updateImageSetMetadataUpdates) {
            this.updateImageSetMetadataUpdates = updateImageSetMetadataUpdates != null ? updateImageSetMetadataUpdates.build()
                    : null;
        }

        @Override
        public final Builder updateImageSetMetadataUpdates(MetadataUpdates updateImageSetMetadataUpdates) {
            this.updateImageSetMetadataUpdates = updateImageSetMetadataUpdates;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageSetMetadataRequest build() {
            return new UpdateImageSetMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
