/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains DICOMUpdates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataUpdates implements SdkPojo, Serializable, ToCopyableBuilder<MetadataUpdates.Builder, MetadataUpdates> {
    private static final SdkField<DICOMUpdates> DICOM_UPDATES_FIELD = SdkField.<DICOMUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("DICOMUpdates").getter(getter(MetadataUpdates::dicomUpdates)).setter(setter(Builder::dicomUpdates))
            .constructor(DICOMUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMUpdates").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final DICOMUpdates dicomUpdates;

    private final Type type;

    private MetadataUpdates(BuilderImpl builder) {
        this.dicomUpdates = builder.dicomUpdates;
        this.type = builder.type;
    }

    /**
     * <p>
     * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     * </p>
     * 
     * @return The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     */
    public final DICOMUpdates dicomUpdates() {
        return dicomUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dicomUpdates());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataUpdates)) {
            return false;
        }
        MetadataUpdates other = (MetadataUpdates) obj;
        return Objects.equals(dicomUpdates(), other.dicomUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataUpdates").add("DICOMUpdates", dicomUpdates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DICOMUpdates":
            return Optional.ofNullable(clazz.cast(dicomUpdates()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dicomUpdates()} initialized to the given value.
     *
     * <p>
     * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     * </p>
     * 
     * @param dicomUpdates
     *        The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     */
    public static MetadataUpdates fromDicomUpdates(DICOMUpdates dicomUpdates) {
        return builder().dicomUpdates(dicomUpdates).build();
    }

    /**
     * Create an instance of this class with {@link #dicomUpdates()} initialized to the given value.
     *
     * <p>
     * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     * </p>
     * 
     * @param dicomUpdates
     *        The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
     */
    public static MetadataUpdates fromDicomUpdates(Consumer<DICOMUpdates.Builder> dicomUpdates) {
        DICOMUpdates.Builder builder = DICOMUpdates.builder();
        dicomUpdates.accept(builder);
        return fromDicomUpdates(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataUpdates, T> g) {
        return obj -> g.apply((MetadataUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataUpdates> {
        /**
         * <p>
         * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
         * </p>
         * 
         * @param dicomUpdates
         *        The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomUpdates(DICOMUpdates dicomUpdates);

        /**
         * <p>
         * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DICOMUpdates.Builder} avoiding the need
         * to create one manually via {@link DICOMUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DICOMUpdates.Builder#build()} is called immediately and its
         * result is passed to {@link #dicomUpdates(DICOMUpdates)}.
         * 
         * @param dicomUpdates
         *        a consumer that will call methods on {@link DICOMUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dicomUpdates(DICOMUpdates)
         */
        default Builder dicomUpdates(Consumer<DICOMUpdates.Builder> dicomUpdates) {
            return dicomUpdates(DICOMUpdates.builder().applyMutation(dicomUpdates).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DICOMUpdates dicomUpdates;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataUpdates model) {
            dicomUpdates(model.dicomUpdates);
        }

        public final DICOMUpdates.Builder getDicomUpdates() {
            return dicomUpdates != null ? dicomUpdates.toBuilder() : null;
        }

        public final void setDicomUpdates(DICOMUpdates.BuilderImpl dicomUpdates) {
            Object oldValue = this.dicomUpdates;
            this.dicomUpdates = dicomUpdates != null ? dicomUpdates.build() : null;
            handleUnionValueChange(Type.DICOM_UPDATES, oldValue, this.dicomUpdates);
        }

        @Override
        public final Builder dicomUpdates(DICOMUpdates dicomUpdates) {
            Object oldValue = this.dicomUpdates;
            this.dicomUpdates = dicomUpdates;
            handleUnionValueChange(Type.DICOM_UPDATES, oldValue, this.dicomUpdates);
            return this;
        }

        @Override
        public MetadataUpdates build() {
            return new MetadataUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MetadataUpdates#type()
     */
    public enum Type {
        DICOM_UPDATES,

        UNKNOWN_TO_SDK_VERSION
    }
}
