/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImageSetResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<GetImageSetResponse.Builder, GetImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(GetImageSetResponse::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(GetImageSetResponse::imageSetId)).setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionId").getter(getter(GetImageSetResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetState").getter(getter(GetImageSetResponse::imageSetStateAsString))
            .setter(setter(Builder::imageSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()).build();

    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetWorkflowStatus").getter(getter(GetImageSetResponse::imageSetWorkflowStatusAsString))
            .setter(setter(Builder::imageSetWorkflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetImageSetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetImageSetResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deletedAt").getter(getter(GetImageSetResponse::deletedAt)).setter(setter(Builder::deletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GetImageSetResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> IMAGE_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetArn").getter(getter(GetImageSetResponse::imageSetArn)).setter(setter(Builder::imageSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            IMAGE_SET_ID_FIELD, VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, DELETED_AT_FIELD, MESSAGE_FIELD, IMAGE_SET_ARN_FIELD));

    private final String datastoreId;

    private final String imageSetId;

    private final String versionId;

    private final String imageSetState;

    private final String imageSetWorkflowStatus;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Instant deletedAt;

    private final String message;

    private final String imageSetArn;

    private GetImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.versionId = builder.versionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.deletedAt = builder.deletedAt;
        this.message = builder.message;
        this.imageSetArn = builder.imageSetArn;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The image set version identifier.
     * </p>
     * 
     * @return The image set version identifier.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(imageSetState);
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final String imageSetStateAsString() {
        return imageSetState;
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(imageSetWorkflowStatus);
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final String imageSetWorkflowStatusAsString() {
        return imageSetWorkflowStatus;
    }

    /**
     * <p>
     * The timestamp when image set properties were created.
     * </p>
     * 
     * @return The timestamp when image set properties were created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when image set properties were updated.
     * </p>
     * 
     * @return The timestamp when image set properties were updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The timestamp when the image set properties were deleted.
     * </p>
     * 
     * @return The timestamp when the image set properties were deleted.
     */
    public final Instant deletedAt() {
        return deletedAt;
    }

    /**
     * <p>
     * The error message thrown if an image set action fails.
     * </p>
     * 
     * @return The error message thrown if an image set action fails.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) assigned to the image set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) assigned to the image set.
     */
    public final String imageSetArn() {
        return imageSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageSetResponse)) {
            return false;
        }
        GetImageSetResponse other = (GetImageSetResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(imageSetId(), other.imageSetId())
                && Objects.equals(versionId(), other.versionId())
                && Objects.equals(imageSetStateAsString(), other.imageSetStateAsString())
                && Objects.equals(imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(deletedAt(), other.deletedAt()) && Objects.equals(message(), other.message())
                && Objects.equals(imageSetArn(), other.imageSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImageSetResponse").add("DatastoreId", datastoreId()).add("ImageSetId", imageSetId())
                .add("VersionId", versionId()).add("ImageSetState", imageSetStateAsString())
                .add("ImageSetWorkflowStatus", imageSetWorkflowStatusAsString()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("DeletedAt", deletedAt()).add("Message", message())
                .add("ImageSetArn", imageSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "imageSetState":
            return Optional.ofNullable(clazz.cast(imageSetStateAsString()));
        case "imageSetWorkflowStatus":
            return Optional.ofNullable(clazz.cast(imageSetWorkflowStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "deletedAt":
            return Optional.ofNullable(clazz.cast(deletedAt()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "imageSetArn":
            return Optional.ofNullable(clazz.cast(imageSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImageSetResponse, T> g) {
        return obj -> g.apply((GetImageSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetImageSetResponse> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The image set version identifier.
         * </p>
         * 
         * @param versionId
         *        The image set version identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(String imageSetState);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(ImageSetState imageSetState);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(String imageSetWorkflowStatus);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus);

        /**
         * <p>
         * The timestamp when image set properties were created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when image set properties were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when image set properties were updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when image set properties were updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The timestamp when the image set properties were deleted.
         * </p>
         * 
         * @param deletedAt
         *        The timestamp when the image set properties were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedAt(Instant deletedAt);

        /**
         * <p>
         * The error message thrown if an image set action fails.
         * </p>
         * 
         * @param message
         *        The error message thrown if an image set action fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The Amazon Resource Name (ARN) assigned to the image set.
         * </p>
         * 
         * @param imageSetArn
         *        The Amazon Resource Name (ARN) assigned to the image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetArn(String imageSetArn);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private String imageSetId;

        private String versionId;

        private String imageSetState;

        private String imageSetWorkflowStatus;

        private Instant createdAt;

        private Instant updatedAt;

        private Instant deletedAt;

        private String message;

        private String imageSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageSetResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            imageSetId(model.imageSetId);
            versionId(model.versionId);
            imageSetState(model.imageSetState);
            imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            deletedAt(model.deletedAt);
            message(model.message);
            imageSetArn(model.imageSetArn);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getImageSetState() {
            return imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getImageSetArn() {
            return imageSetArn;
        }

        public final void setImageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
        }

        @Override
        public final Builder imageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
            return this;
        }

        @Override
        public GetImageSetResponse build() {
            return new GetImageSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
