/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteImageSetResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<DeleteImageSetResponse.Builder, DeleteImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(DeleteImageSetResponse::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(DeleteImageSetResponse::imageSetId)).setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetState").getter(getter(DeleteImageSetResponse::imageSetStateAsString))
            .setter(setter(Builder::imageSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()).build();

    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetWorkflowStatus").getter(getter(DeleteImageSetResponse::imageSetWorkflowStatusAsString))
            .setter(setter(Builder::imageSetWorkflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            IMAGE_SET_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD));

    private final String datastoreId;

    private final String imageSetId;

    private final String imageSetState;

    private final String imageSetWorkflowStatus;

    private DeleteImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(imageSetState);
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final String imageSetStateAsString() {
        return imageSetState;
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(imageSetWorkflowStatus);
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final String imageSetWorkflowStatusAsString() {
        return imageSetWorkflowStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetWorkflowStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImageSetResponse)) {
            return false;
        }
        DeleteImageSetResponse other = (DeleteImageSetResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(imageSetId(), other.imageSetId())
                && Objects.equals(imageSetStateAsString(), other.imageSetStateAsString())
                && Objects.equals(imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteImageSetResponse").add("DatastoreId", datastoreId()).add("ImageSetId", imageSetId())
                .add("ImageSetState", imageSetStateAsString()).add("ImageSetWorkflowStatus", imageSetWorkflowStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "imageSetState":
            return Optional.ofNullable(clazz.cast(imageSetStateAsString()));
        case "imageSetWorkflowStatus":
            return Optional.ofNullable(clazz.cast(imageSetWorkflowStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteImageSetResponse, T> g) {
        return obj -> g.apply((DeleteImageSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteImageSetResponse> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(String imageSetState);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(ImageSetState imageSetState);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(String imageSetWorkflowStatus);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private String imageSetId;

        private String imageSetState;

        private String imageSetWorkflowStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImageSetResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            imageSetId(model.imageSetId);
            imageSetState(model.imageSetState);
            imageSetWorkflowStatus(model.imageSetWorkflowStatus);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getImageSetState() {
            return imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        @Override
        public DeleteImageSetResponse build() {
            return new DeleteImageSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
