/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of summaries of data stores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreSummary.Builder, DatastoreSummary> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(DatastoreSummary::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreName").getter(getter(DatastoreSummary::datastoreName)).setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()).build();

    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreStatus").getter(getter(DatastoreSummary::datastoreStatusAsString))
            .setter(setter(Builder::datastoreStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStatus").build()).build();

    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreArn").getter(getter(DatastoreSummary::datastoreArn)).setter(setter(Builder::datastoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DatastoreSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(DatastoreSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            DATASTORE_NAME_FIELD, DATASTORE_STATUS_FIELD, DATASTORE_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datastoreId;

    private final String datastoreName;

    private final String datastoreStatus;

    private final String datastoreArn;

    private final Instant createdAt;

    private final Instant updatedAt;

    private DatastoreSummary(BuilderImpl builder) {
        this.datastoreId = builder.datastoreId;
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.datastoreArn = builder.datastoreArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The data store name.
     * </p>
     * 
     * @return The data store name.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * The data store status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The data store status.
     * @see DatastoreStatus
     */
    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(datastoreStatus);
    }

    /**
     * <p>
     * The data store status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The data store status.
     * @see DatastoreStatus
     */
    public final String datastoreStatusAsString() {
        return datastoreStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the data store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the data store.
     */
    public final String datastoreArn() {
        return datastoreArn;
    }

    /**
     * <p>
     * The timestamp when the data store was created.
     * </p>
     * 
     * @return The timestamp when the data store was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the data store was last updated.
     * </p>
     * 
     * @return The timestamp when the data store was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreSummary)) {
            return false;
        }
        DatastoreSummary other = (DatastoreSummary) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStatusAsString(), other.datastoreStatusAsString())
                && Objects.equals(datastoreArn(), other.datastoreArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreSummary").add("DatastoreId", datastoreId()).add("DatastoreName", datastoreName())
                .add("DatastoreStatus", datastoreStatusAsString()).add("DatastoreArn", datastoreArn())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "datastoreStatus":
            return Optional.ofNullable(clazz.cast(datastoreStatusAsString()));
        case "datastoreArn":
            return Optional.ofNullable(clazz.cast(datastoreArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreSummary, T> g) {
        return obj -> g.apply((DatastoreSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreSummary> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The data store name.
         * </p>
         * 
         * @param datastoreName
         *        The data store name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * The data store status.
         * </p>
         * 
         * @param datastoreStatus
         *        The data store status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(String datastoreStatus);

        /**
         * <p>
         * The data store status.
         * </p>
         * 
         * @param datastoreStatus
         *        The data store status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(DatastoreStatus datastoreStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the data store.
         * </p>
         * 
         * @param datastoreArn
         *        The Amazon Resource Name (ARN) for the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreArn(String datastoreArn);

        /**
         * <p>
         * The timestamp when the data store was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the data store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the data store was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the data store was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String datastoreId;

        private String datastoreName;

        private String datastoreStatus;

        private String datastoreArn;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreSummary model) {
            datastoreId(model.datastoreId);
            datastoreName(model.datastoreName);
            datastoreStatus(model.datastoreStatus);
            datastoreArn(model.datastoreArn);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final String getDatastoreArn() {
            return datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DatastoreSummary build() {
            return new DatastoreSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
