/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object containing <code>removableAttributes</code> and <code>updatableAttributes</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DICOMUpdates implements SdkPojo, Serializable, ToCopyableBuilder<DICOMUpdates.Builder, DICOMUpdates> {
    private static final SdkField<SdkBytes> REMOVABLE_ATTRIBUTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("removableAttributes").getter(getter(DICOMUpdates::removableAttributes))
            .setter(setter(Builder::removableAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removableAttributes").build())
            .build();

    private static final SdkField<SdkBytes> UPDATABLE_ATTRIBUTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("updatableAttributes").getter(getter(DICOMUpdates::updatableAttributes))
            .setter(setter(Builder::updatableAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatableAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOVABLE_ATTRIBUTES_FIELD,
            UPDATABLE_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes removableAttributes;

    private final SdkBytes updatableAttributes;

    private DICOMUpdates(BuilderImpl builder) {
        this.removableAttributes = builder.removableAttributes;
        this.updatableAttributes = builder.updatableAttributes;
    }

    /**
     * <p>
     * The DICOM tags to be removed from <code>ImageSetMetadata</code>.
     * </p>
     * 
     * @return The DICOM tags to be removed from <code>ImageSetMetadata</code>.
     */
    public final SdkBytes removableAttributes() {
        return removableAttributes;
    }

    /**
     * <p>
     * The DICOM tags that need to be updated in <code>ImageSetMetadata</code>.
     * </p>
     * 
     * @return The DICOM tags that need to be updated in <code>ImageSetMetadata</code>.
     */
    public final SdkBytes updatableAttributes() {
        return updatableAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(removableAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(updatableAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DICOMUpdates)) {
            return false;
        }
        DICOMUpdates other = (DICOMUpdates) obj;
        return Objects.equals(removableAttributes(), other.removableAttributes())
                && Objects.equals(updatableAttributes(), other.updatableAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DICOMUpdates")
                .add("RemovableAttributes", removableAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdatableAttributes", updatableAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "removableAttributes":
            return Optional.ofNullable(clazz.cast(removableAttributes()));
        case "updatableAttributes":
            return Optional.ofNullable(clazz.cast(updatableAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DICOMUpdates, T> g) {
        return obj -> g.apply((DICOMUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DICOMUpdates> {
        /**
         * <p>
         * The DICOM tags to be removed from <code>ImageSetMetadata</code>.
         * </p>
         * 
         * @param removableAttributes
         *        The DICOM tags to be removed from <code>ImageSetMetadata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removableAttributes(SdkBytes removableAttributes);

        /**
         * <p>
         * The DICOM tags that need to be updated in <code>ImageSetMetadata</code>.
         * </p>
         * 
         * @param updatableAttributes
         *        The DICOM tags that need to be updated in <code>ImageSetMetadata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatableAttributes(SdkBytes updatableAttributes);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes removableAttributes;

        private SdkBytes updatableAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DICOMUpdates model) {
            removableAttributes(model.removableAttributes);
            updatableAttributes(model.updatableAttributes);
        }

        public final ByteBuffer getRemovableAttributes() {
            return removableAttributes == null ? null : removableAttributes.asByteBuffer();
        }

        public final void setRemovableAttributes(ByteBuffer removableAttributes) {
            removableAttributes(removableAttributes == null ? null : SdkBytes.fromByteBuffer(removableAttributes));
        }

        @Override
        public final Builder removableAttributes(SdkBytes removableAttributes) {
            this.removableAttributes = removableAttributes;
            return this;
        }

        public final ByteBuffer getUpdatableAttributes() {
            return updatableAttributes == null ? null : updatableAttributes.asByteBuffer();
        }

        public final void setUpdatableAttributes(ByteBuffer updatableAttributes) {
            updatableAttributes(updatableAttributes == null ? null : SdkBytes.fromByteBuffer(updatableAttributes));
        }

        @Override
        public final Builder updatableAttributes(SdkBytes updatableAttributes) {
            this.updatableAttributes = updatableAttributes;
            return this;
        }

        @Override
        public DICOMUpdates build() {
            return new DICOMUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
