/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DICOM attributes returned as a part of a response. Each image set has these properties as part of a search
 * result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DICOMTags implements SdkPojo, Serializable, ToCopyableBuilder<DICOMTags.Builder, DICOMTags> {
    private static final SdkField<String> DICOM_PATIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMPatientId").getter(getter(DICOMTags::dicomPatientId)).setter(setter(Builder::dicomPatientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientId").build()).build();

    private static final SdkField<String> DICOM_PATIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMPatientName").getter(getter(DICOMTags::dicomPatientName)).setter(setter(Builder::dicomPatientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientName").build()).build();

    private static final SdkField<String> DICOM_PATIENT_BIRTH_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMPatientBirthDate").getter(getter(DICOMTags::dicomPatientBirthDate))
            .setter(setter(Builder::dicomPatientBirthDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientBirthDate").build())
            .build();

    private static final SdkField<String> DICOM_PATIENT_SEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMPatientSex").getter(getter(DICOMTags::dicomPatientSex)).setter(setter(Builder::dicomPatientSex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientSex").build()).build();

    private static final SdkField<String> DICOM_STUDY_INSTANCE_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyInstanceUID").getter(getter(DICOMTags::dicomStudyInstanceUID))
            .setter(setter(Builder::dicomStudyInstanceUID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyInstanceUID").build())
            .build();

    private static final SdkField<String> DICOM_STUDY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyId").getter(getter(DICOMTags::dicomStudyId)).setter(setter(Builder::dicomStudyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyId").build()).build();

    private static final SdkField<String> DICOM_STUDY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyDescription").getter(getter(DICOMTags::dicomStudyDescription))
            .setter(setter(Builder::dicomStudyDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyDescription").build())
            .build();

    private static final SdkField<Integer> DICOM_NUMBER_OF_STUDY_RELATED_SERIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DICOMNumberOfStudyRelatedSeries")
            .getter(getter(DICOMTags::dicomNumberOfStudyRelatedSeries))
            .setter(setter(Builder::dicomNumberOfStudyRelatedSeries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMNumberOfStudyRelatedSeries")
                    .build()).build();

    private static final SdkField<Integer> DICOM_NUMBER_OF_STUDY_RELATED_INSTANCES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DICOMNumberOfStudyRelatedInstances")
            .getter(getter(DICOMTags::dicomNumberOfStudyRelatedInstances))
            .setter(setter(Builder::dicomNumberOfStudyRelatedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMNumberOfStudyRelatedInstances")
                    .build()).build();

    private static final SdkField<String> DICOM_ACCESSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMAccessionNumber").getter(getter(DICOMTags::dicomAccessionNumber))
            .setter(setter(Builder::dicomAccessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMAccessionNumber").build())
            .build();

    private static final SdkField<String> DICOM_STUDY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyDate").getter(getter(DICOMTags::dicomStudyDate)).setter(setter(Builder::dicomStudyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyDate").build()).build();

    private static final SdkField<String> DICOM_STUDY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyTime").getter(getter(DICOMTags::dicomStudyTime)).setter(setter(Builder::dicomStudyTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_PATIENT_ID_FIELD,
            DICOM_PATIENT_NAME_FIELD, DICOM_PATIENT_BIRTH_DATE_FIELD, DICOM_PATIENT_SEX_FIELD, DICOM_STUDY_INSTANCE_UID_FIELD,
            DICOM_STUDY_ID_FIELD, DICOM_STUDY_DESCRIPTION_FIELD, DICOM_NUMBER_OF_STUDY_RELATED_SERIES_FIELD,
            DICOM_NUMBER_OF_STUDY_RELATED_INSTANCES_FIELD, DICOM_ACCESSION_NUMBER_FIELD, DICOM_STUDY_DATE_FIELD,
            DICOM_STUDY_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dicomPatientId;

    private final String dicomPatientName;

    private final String dicomPatientBirthDate;

    private final String dicomPatientSex;

    private final String dicomStudyInstanceUID;

    private final String dicomStudyId;

    private final String dicomStudyDescription;

    private final Integer dicomNumberOfStudyRelatedSeries;

    private final Integer dicomNumberOfStudyRelatedInstances;

    private final String dicomAccessionNumber;

    private final String dicomStudyDate;

    private final String dicomStudyTime;

    private DICOMTags(BuilderImpl builder) {
        this.dicomPatientId = builder.dicomPatientId;
        this.dicomPatientName = builder.dicomPatientName;
        this.dicomPatientBirthDate = builder.dicomPatientBirthDate;
        this.dicomPatientSex = builder.dicomPatientSex;
        this.dicomStudyInstanceUID = builder.dicomStudyInstanceUID;
        this.dicomStudyId = builder.dicomStudyId;
        this.dicomStudyDescription = builder.dicomStudyDescription;
        this.dicomNumberOfStudyRelatedSeries = builder.dicomNumberOfStudyRelatedSeries;
        this.dicomNumberOfStudyRelatedInstances = builder.dicomNumberOfStudyRelatedInstances;
        this.dicomAccessionNumber = builder.dicomAccessionNumber;
        this.dicomStudyDate = builder.dicomStudyDate;
        this.dicomStudyTime = builder.dicomStudyTime;
    }

    /**
     * <p>
     * The unique identifier for a patient in a DICOM Study.
     * </p>
     * 
     * @return The unique identifier for a patient in a DICOM Study.
     */
    public final String dicomPatientId() {
        return dicomPatientId;
    }

    /**
     * <p>
     * The patient name.
     * </p>
     * 
     * @return The patient name.
     */
    public final String dicomPatientName() {
        return dicomPatientName;
    }

    /**
     * <p>
     * The patient birth date.
     * </p>
     * 
     * @return The patient birth date.
     */
    public final String dicomPatientBirthDate() {
        return dicomPatientBirthDate;
    }

    /**
     * <p>
     * The patient sex.
     * </p>
     * 
     * @return The patient sex.
     */
    public final String dicomPatientSex() {
        return dicomPatientSex;
    }

    /**
     * <p>
     * The DICOM provided identifier for studyInstanceUid.&gt;
     * </p>
     * 
     * @return The DICOM provided identifier for studyInstanceUid.&gt;
     */
    public final String dicomStudyInstanceUID() {
        return dicomStudyInstanceUID;
    }

    /**
     * <p>
     * The DICOM provided studyId.
     * </p>
     * 
     * @return The DICOM provided studyId.
     */
    public final String dicomStudyId() {
        return dicomStudyId;
    }

    /**
     * <p>
     * The description of the study.
     * </p>
     * 
     * @return The description of the study.
     */
    public final String dicomStudyDescription() {
        return dicomStudyDescription;
    }

    /**
     * <p>
     * The total number of series in the DICOM study.
     * </p>
     * 
     * @return The total number of series in the DICOM study.
     */
    public final Integer dicomNumberOfStudyRelatedSeries() {
        return dicomNumberOfStudyRelatedSeries;
    }

    /**
     * <p>
     * The total number of instances in the DICOM study.
     * </p>
     * 
     * @return The total number of instances in the DICOM study.
     */
    public final Integer dicomNumberOfStudyRelatedInstances() {
        return dicomNumberOfStudyRelatedInstances;
    }

    /**
     * <p>
     * The accession number for the DICOM study.
     * </p>
     * 
     * @return The accession number for the DICOM study.
     */
    public final String dicomAccessionNumber() {
        return dicomAccessionNumber;
    }

    /**
     * <p>
     * The study date.
     * </p>
     * 
     * @return The study date.
     */
    public final String dicomStudyDate() {
        return dicomStudyDate;
    }

    /**
     * <p>
     * The study time.
     * </p>
     * 
     * @return The study time.
     */
    public final String dicomStudyTime() {
        return dicomStudyTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dicomPatientId());
        hashCode = 31 * hashCode + Objects.hashCode(dicomPatientName());
        hashCode = 31 * hashCode + Objects.hashCode(dicomPatientBirthDate());
        hashCode = 31 * hashCode + Objects.hashCode(dicomPatientSex());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyInstanceUID());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyId());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dicomNumberOfStudyRelatedSeries());
        hashCode = 31 * hashCode + Objects.hashCode(dicomNumberOfStudyRelatedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(dicomAccessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyDate());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DICOMTags)) {
            return false;
        }
        DICOMTags other = (DICOMTags) obj;
        return Objects.equals(dicomPatientId(), other.dicomPatientId())
                && Objects.equals(dicomPatientName(), other.dicomPatientName())
                && Objects.equals(dicomPatientBirthDate(), other.dicomPatientBirthDate())
                && Objects.equals(dicomPatientSex(), other.dicomPatientSex())
                && Objects.equals(dicomStudyInstanceUID(), other.dicomStudyInstanceUID())
                && Objects.equals(dicomStudyId(), other.dicomStudyId())
                && Objects.equals(dicomStudyDescription(), other.dicomStudyDescription())
                && Objects.equals(dicomNumberOfStudyRelatedSeries(), other.dicomNumberOfStudyRelatedSeries())
                && Objects.equals(dicomNumberOfStudyRelatedInstances(), other.dicomNumberOfStudyRelatedInstances())
                && Objects.equals(dicomAccessionNumber(), other.dicomAccessionNumber())
                && Objects.equals(dicomStudyDate(), other.dicomStudyDate())
                && Objects.equals(dicomStudyTime(), other.dicomStudyTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DICOMTags")
                .add("DICOMPatientId", dicomPatientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMPatientName", dicomPatientName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMPatientBirthDate", dicomPatientBirthDate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMPatientSex", dicomPatientSex() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyInstanceUID", dicomStudyInstanceUID() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyId", dicomStudyId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyDescription", dicomStudyDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMNumberOfStudyRelatedSeries", dicomNumberOfStudyRelatedSeries())
                .add("DICOMNumberOfStudyRelatedInstances", dicomNumberOfStudyRelatedInstances())
                .add("DICOMAccessionNumber", dicomAccessionNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyDate", dicomStudyDate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyTime", dicomStudyTime() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DICOMPatientId":
            return Optional.ofNullable(clazz.cast(dicomPatientId()));
        case "DICOMPatientName":
            return Optional.ofNullable(clazz.cast(dicomPatientName()));
        case "DICOMPatientBirthDate":
            return Optional.ofNullable(clazz.cast(dicomPatientBirthDate()));
        case "DICOMPatientSex":
            return Optional.ofNullable(clazz.cast(dicomPatientSex()));
        case "DICOMStudyInstanceUID":
            return Optional.ofNullable(clazz.cast(dicomStudyInstanceUID()));
        case "DICOMStudyId":
            return Optional.ofNullable(clazz.cast(dicomStudyId()));
        case "DICOMStudyDescription":
            return Optional.ofNullable(clazz.cast(dicomStudyDescription()));
        case "DICOMNumberOfStudyRelatedSeries":
            return Optional.ofNullable(clazz.cast(dicomNumberOfStudyRelatedSeries()));
        case "DICOMNumberOfStudyRelatedInstances":
            return Optional.ofNullable(clazz.cast(dicomNumberOfStudyRelatedInstances()));
        case "DICOMAccessionNumber":
            return Optional.ofNullable(clazz.cast(dicomAccessionNumber()));
        case "DICOMStudyDate":
            return Optional.ofNullable(clazz.cast(dicomStudyDate()));
        case "DICOMStudyTime":
            return Optional.ofNullable(clazz.cast(dicomStudyTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DICOMTags, T> g) {
        return obj -> g.apply((DICOMTags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DICOMTags> {
        /**
         * <p>
         * The unique identifier for a patient in a DICOM Study.
         * </p>
         * 
         * @param dicomPatientId
         *        The unique identifier for a patient in a DICOM Study.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomPatientId(String dicomPatientId);

        /**
         * <p>
         * The patient name.
         * </p>
         * 
         * @param dicomPatientName
         *        The patient name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomPatientName(String dicomPatientName);

        /**
         * <p>
         * The patient birth date.
         * </p>
         * 
         * @param dicomPatientBirthDate
         *        The patient birth date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomPatientBirthDate(String dicomPatientBirthDate);

        /**
         * <p>
         * The patient sex.
         * </p>
         * 
         * @param dicomPatientSex
         *        The patient sex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomPatientSex(String dicomPatientSex);

        /**
         * <p>
         * The DICOM provided identifier for studyInstanceUid.&gt;
         * </p>
         * 
         * @param dicomStudyInstanceUID
         *        The DICOM provided identifier for studyInstanceUid.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyInstanceUID(String dicomStudyInstanceUID);

        /**
         * <p>
         * The DICOM provided studyId.
         * </p>
         * 
         * @param dicomStudyId
         *        The DICOM provided studyId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyId(String dicomStudyId);

        /**
         * <p>
         * The description of the study.
         * </p>
         * 
         * @param dicomStudyDescription
         *        The description of the study.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyDescription(String dicomStudyDescription);

        /**
         * <p>
         * The total number of series in the DICOM study.
         * </p>
         * 
         * @param dicomNumberOfStudyRelatedSeries
         *        The total number of series in the DICOM study.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomNumberOfStudyRelatedSeries(Integer dicomNumberOfStudyRelatedSeries);

        /**
         * <p>
         * The total number of instances in the DICOM study.
         * </p>
         * 
         * @param dicomNumberOfStudyRelatedInstances
         *        The total number of instances in the DICOM study.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomNumberOfStudyRelatedInstances(Integer dicomNumberOfStudyRelatedInstances);

        /**
         * <p>
         * The accession number for the DICOM study.
         * </p>
         * 
         * @param dicomAccessionNumber
         *        The accession number for the DICOM study.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomAccessionNumber(String dicomAccessionNumber);

        /**
         * <p>
         * The study date.
         * </p>
         * 
         * @param dicomStudyDate
         *        The study date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyDate(String dicomStudyDate);

        /**
         * <p>
         * The study time.
         * </p>
         * 
         * @param dicomStudyTime
         *        The study time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyTime(String dicomStudyTime);
    }

    static final class BuilderImpl implements Builder {
        private String dicomPatientId;

        private String dicomPatientName;

        private String dicomPatientBirthDate;

        private String dicomPatientSex;

        private String dicomStudyInstanceUID;

        private String dicomStudyId;

        private String dicomStudyDescription;

        private Integer dicomNumberOfStudyRelatedSeries;

        private Integer dicomNumberOfStudyRelatedInstances;

        private String dicomAccessionNumber;

        private String dicomStudyDate;

        private String dicomStudyTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DICOMTags model) {
            dicomPatientId(model.dicomPatientId);
            dicomPatientName(model.dicomPatientName);
            dicomPatientBirthDate(model.dicomPatientBirthDate);
            dicomPatientSex(model.dicomPatientSex);
            dicomStudyInstanceUID(model.dicomStudyInstanceUID);
            dicomStudyId(model.dicomStudyId);
            dicomStudyDescription(model.dicomStudyDescription);
            dicomNumberOfStudyRelatedSeries(model.dicomNumberOfStudyRelatedSeries);
            dicomNumberOfStudyRelatedInstances(model.dicomNumberOfStudyRelatedInstances);
            dicomAccessionNumber(model.dicomAccessionNumber);
            dicomStudyDate(model.dicomStudyDate);
            dicomStudyTime(model.dicomStudyTime);
        }

        public final String getDicomPatientId() {
            return dicomPatientId;
        }

        public final void setDicomPatientId(String dicomPatientId) {
            this.dicomPatientId = dicomPatientId;
        }

        @Override
        public final Builder dicomPatientId(String dicomPatientId) {
            this.dicomPatientId = dicomPatientId;
            return this;
        }

        public final String getDicomPatientName() {
            return dicomPatientName;
        }

        public final void setDicomPatientName(String dicomPatientName) {
            this.dicomPatientName = dicomPatientName;
        }

        @Override
        public final Builder dicomPatientName(String dicomPatientName) {
            this.dicomPatientName = dicomPatientName;
            return this;
        }

        public final String getDicomPatientBirthDate() {
            return dicomPatientBirthDate;
        }

        public final void setDicomPatientBirthDate(String dicomPatientBirthDate) {
            this.dicomPatientBirthDate = dicomPatientBirthDate;
        }

        @Override
        public final Builder dicomPatientBirthDate(String dicomPatientBirthDate) {
            this.dicomPatientBirthDate = dicomPatientBirthDate;
            return this;
        }

        public final String getDicomPatientSex() {
            return dicomPatientSex;
        }

        public final void setDicomPatientSex(String dicomPatientSex) {
            this.dicomPatientSex = dicomPatientSex;
        }

        @Override
        public final Builder dicomPatientSex(String dicomPatientSex) {
            this.dicomPatientSex = dicomPatientSex;
            return this;
        }

        public final String getDicomStudyInstanceUID() {
            return dicomStudyInstanceUID;
        }

        public final void setDicomStudyInstanceUID(String dicomStudyInstanceUID) {
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
        }

        @Override
        public final Builder dicomStudyInstanceUID(String dicomStudyInstanceUID) {
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
            return this;
        }

        public final String getDicomStudyId() {
            return dicomStudyId;
        }

        public final void setDicomStudyId(String dicomStudyId) {
            this.dicomStudyId = dicomStudyId;
        }

        @Override
        public final Builder dicomStudyId(String dicomStudyId) {
            this.dicomStudyId = dicomStudyId;
            return this;
        }

        public final String getDicomStudyDescription() {
            return dicomStudyDescription;
        }

        public final void setDicomStudyDescription(String dicomStudyDescription) {
            this.dicomStudyDescription = dicomStudyDescription;
        }

        @Override
        public final Builder dicomStudyDescription(String dicomStudyDescription) {
            this.dicomStudyDescription = dicomStudyDescription;
            return this;
        }

        public final Integer getDicomNumberOfStudyRelatedSeries() {
            return dicomNumberOfStudyRelatedSeries;
        }

        public final void setDicomNumberOfStudyRelatedSeries(Integer dicomNumberOfStudyRelatedSeries) {
            this.dicomNumberOfStudyRelatedSeries = dicomNumberOfStudyRelatedSeries;
        }

        @Override
        public final Builder dicomNumberOfStudyRelatedSeries(Integer dicomNumberOfStudyRelatedSeries) {
            this.dicomNumberOfStudyRelatedSeries = dicomNumberOfStudyRelatedSeries;
            return this;
        }

        public final Integer getDicomNumberOfStudyRelatedInstances() {
            return dicomNumberOfStudyRelatedInstances;
        }

        public final void setDicomNumberOfStudyRelatedInstances(Integer dicomNumberOfStudyRelatedInstances) {
            this.dicomNumberOfStudyRelatedInstances = dicomNumberOfStudyRelatedInstances;
        }

        @Override
        public final Builder dicomNumberOfStudyRelatedInstances(Integer dicomNumberOfStudyRelatedInstances) {
            this.dicomNumberOfStudyRelatedInstances = dicomNumberOfStudyRelatedInstances;
            return this;
        }

        public final String getDicomAccessionNumber() {
            return dicomAccessionNumber;
        }

        public final void setDicomAccessionNumber(String dicomAccessionNumber) {
            this.dicomAccessionNumber = dicomAccessionNumber;
        }

        @Override
        public final Builder dicomAccessionNumber(String dicomAccessionNumber) {
            this.dicomAccessionNumber = dicomAccessionNumber;
            return this;
        }

        public final String getDicomStudyDate() {
            return dicomStudyDate;
        }

        public final void setDicomStudyDate(String dicomStudyDate) {
            this.dicomStudyDate = dicomStudyDate;
        }

        @Override
        public final Builder dicomStudyDate(String dicomStudyDate) {
            this.dicomStudyDate = dicomStudyDate;
            return this;
        }

        public final String getDicomStudyTime() {
            return dicomStudyTime;
        }

        public final void setDicomStudyTime(String dicomStudyTime) {
            this.dicomStudyTime = dicomStudyTime;
        }

        @Override
        public final Builder dicomStudyTime(String dicomStudyTime) {
            this.dicomStudyTime = dicomStudyTime;
            return this;
        }

        @Override
        public DICOMTags build() {
            return new DICOMTags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
