/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.medicalimaging.DefaultMedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.DefaultMedicalImagingBaseClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingServiceClientConfiguration;
import software.amazon.awssdk.services.medicalimaging.endpoints.MedicalImagingEndpointProvider;

@SdkInternalApi
final class DefaultMedicalImagingAsyncClientBuilder
extends DefaultMedicalImagingBaseClientBuilder<MedicalImagingAsyncClientBuilder, MedicalImagingAsyncClient>
implements MedicalImagingAsyncClientBuilder {
    DefaultMedicalImagingAsyncClientBuilder() {
    }

    @Override
    public DefaultMedicalImagingAsyncClientBuilder endpointProvider(MedicalImagingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MedicalImagingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMedicalImagingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MedicalImagingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMedicalImagingAsyncClient client = new DefaultMedicalImagingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MedicalImagingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MedicalImagingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

