/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dash manifest configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashPlaylistSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DashPlaylistSettings.Builder, DashPlaylistSettings> {
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(DashPlaylistSettings::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTimeSeconds").getter(getter(DashPlaylistSettings::minBufferTimeSeconds))
            .setter(setter(Builder::minBufferTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBufferTimeSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinUpdatePeriodSeconds").getter(getter(DashPlaylistSettings::minUpdatePeriodSeconds))
            .setter(setter(Builder::minUpdatePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUpdatePeriodSeconds").build())
            .build();

    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuggestedPresentationDelaySeconds")
            .getter(getter(DashPlaylistSettings::suggestedPresentationDelaySeconds))
            .setter(setter(Builder::suggestedPresentationDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedPresentationDelaySeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_WINDOW_SECONDS_FIELD,
            MIN_BUFFER_TIME_SECONDS_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer manifestWindowSeconds;

    private final Integer minBufferTimeSeconds;

    private final Integer minUpdatePeriodSeconds;

    private final Integer suggestedPresentationDelaySeconds;

    private DashPlaylistSettings(BuilderImpl builder) {
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
    }

    /**
     * <p>
     * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     * <code>3600</code> seconds.
     * </p>
     * 
     * @return The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     *         <code>3600</code> seconds.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * <p>
     * Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum value:
     * <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     * </p>
     * 
     * @return Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum
     *         value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     */
    public final Integer minBufferTimeSeconds() {
        return minBufferTimeSeconds;
    }

    /**
     * <p>
     * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
     * Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     * </p>
     * 
     * @return Minimum amount of time (in seconds) that the player should wait before requesting updates to the
     *         manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     */
    public final Integer minUpdatePeriodSeconds() {
        return minUpdatePeriodSeconds;
    }

    /**
     * <p>
     * Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum
     * value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     * </p>
     * 
     * @return Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
     *         Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
     */
    public final Integer suggestedPresentationDelaySeconds() {
        return suggestedPresentationDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(suggestedPresentationDelaySeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPlaylistSettings)) {
            return false;
        }
        DashPlaylistSettings other = (DashPlaylistSettings) obj;
        return Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(minBufferTimeSeconds(), other.minBufferTimeSeconds())
                && Objects.equals(minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds())
                && Objects.equals(suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashPlaylistSettings").add("ManifestWindowSeconds", manifestWindowSeconds())
                .add("MinBufferTimeSeconds", minBufferTimeSeconds()).add("MinUpdatePeriodSeconds", minUpdatePeriodSeconds())
                .add("SuggestedPresentationDelaySeconds", suggestedPresentationDelaySeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "MinBufferTimeSeconds":
            return Optional.ofNullable(clazz.cast(minBufferTimeSeconds()));
        case "MinUpdatePeriodSeconds":
            return Optional.ofNullable(clazz.cast(minUpdatePeriodSeconds()));
        case "SuggestedPresentationDelaySeconds":
            return Optional.ofNullable(clazz.cast(suggestedPresentationDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPlaylistSettings, T> g) {
        return obj -> g.apply((DashPlaylistSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashPlaylistSettings> {
        /**
         * <p>
         * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
         * <code>3600</code> seconds.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum
         *        value: <code>3600</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * <p>
         * Minimum amount of content (measured in seconds) that a player must keep available in the buffer. Minimum
         * value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * </p>
         * 
         * @param minBufferTimeSeconds
         *        Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
         *        Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTimeSeconds(Integer minBufferTimeSeconds);

        /**
         * <p>
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         * Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * </p>
         * 
         * @param minUpdatePeriodSeconds
         *        Minimum amount of time (in seconds) that the player should wait before requesting updates to the
         *        manifest. Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds);

        /**
         * <p>
         * Amount of time (in seconds) that the player should be from the live point at the end of the manifest. Minimum
         * value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * </p>
         * 
         * @param suggestedPresentationDelaySeconds
         *        Amount of time (in seconds) that the player should be from the live point at the end of the manifest.
         *        Minimum value: <code>2</code> seconds. Maximum value: <code>60</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer manifestWindowSeconds;

        private Integer minBufferTimeSeconds;

        private Integer minUpdatePeriodSeconds;

        private Integer suggestedPresentationDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPlaylistSettings model) {
            manifestWindowSeconds(model.manifestWindowSeconds);
            minBufferTimeSeconds(model.minBufferTimeSeconds);
            minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final Integer getMinBufferTimeSeconds() {
            return minBufferTimeSeconds;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return minUpdatePeriodSeconds;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return suggestedPresentationDelaySeconds;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        @Override
        public DashPlaylistSettings build() {
            return new DashPlaylistSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
