/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Mode {
    OFF("OFF"),
    BEHIND_LIVE_EDGE("BEHIND_LIVE_EDGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mode> VALUE_MAP;
    private final String value;

    private Mode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Mode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Mode> knownValues() {
        EnumSet<Mode> knownValues = EnumSet.allOf(Mode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Mode.class, Mode::toString);
    }
}

