/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataAsyncClient;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataBaseClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClient;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataServiceClientConfiguration;
import software.amazon.awssdk.services.mediastoredata.endpoints.MediaStoreDataEndpointProvider;

@SdkInternalApi
final class DefaultMediaStoreDataAsyncClientBuilder
extends DefaultMediaStoreDataBaseClientBuilder<MediaStoreDataAsyncClientBuilder, MediaStoreDataAsyncClient>
implements MediaStoreDataAsyncClientBuilder {
    DefaultMediaStoreDataAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaStoreDataAsyncClientBuilder endpointProvider(MediaStoreDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaStoreDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaStoreDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaStoreDataServiceClientConfiguration serviceClientConfiguration = MediaStoreDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaStoreDataAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

