/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClient;
import software.amazon.awssdk.services.mediapackagevod.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse;
import software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup;

public class ListPackagingGroupsPublisher
implements SdkPublisher<ListPackagingGroupsResponse> {
    private final MediaPackageVodAsyncClient client;
    private final ListPackagingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagingGroupsPublisher(MediaPackageVodAsyncClient client, ListPackagingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagingGroupsPublisher(MediaPackageVodAsyncClient client, ListPackagingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackagingGroup> packagingGroups() {
        Function<ListPackagingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packagingGroups() != null) {
                return response.packagingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackagingGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackagingGroupsResponseFetcher
    implements AsyncPageFetcher<ListPackagingGroupsResponse> {
        private ListPackagingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagingGroupsResponse> nextPage(ListPackagingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListPackagingGroupsPublisher.this.client.listPackagingGroups(ListPackagingGroupsPublisher.this.firstRequest);
            }
            return ListPackagingGroupsPublisher.this.client.listPackagingGroups((ListPackagingGroupsRequest)((Object)ListPackagingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

