/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A CMAF encryption configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafEncryption implements SdkPojo, Serializable, ToCopyableBuilder<CmafEncryption.Builder, CmafEncryption> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConstantInitializationVector")
            .getter(getter(CmafEncryption::constantInitializationVector))
            .setter(setter(Builder::constantInitializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector")
                    .build()).build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).memberName("SpekeKeyProvider")
            .getter(getter(CmafEncryption::spekeKeyProvider)).setter(setter(Builder::spekeKeyProvider))
            .constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSTANT_INITIALIZATION_VECTOR_FIELD, SPEKE_KEY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantInitializationVector;

    private final SpekeKeyProvider spekeKeyProvider;

    private CmafEncryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    /**
     * An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for
     * encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector
     * (IV).
     * 
     * @return An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the
     *         key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant
     *         initialization vector (IV).
     */
    public final String constantInitializationVector() {
        return constantInitializationVector;
    }

    /**
     * Returns the value of the SpekeKeyProvider property for this object.
     * 
     * @return The value of the SpekeKeyProvider property for this object.
     */
    public final SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafEncryption)) {
            return false;
        }
        CmafEncryption other = (CmafEncryption) obj;
        return Objects.equals(constantInitializationVector(), other.constantInitializationVector())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafEncryption").add("ConstantInitializationVector", constantInitializationVector())
                .add("SpekeKeyProvider", spekeKeyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantInitializationVector":
            return Optional.ofNullable(clazz.cast(constantInitializationVector()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafEncryption, T> g) {
        return obj -> g.apply((CmafEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafEncryption> {
        /**
         * An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key
         * for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization
         * vector (IV).
         * 
         * @param constantInitializationVector
         *        An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with
         *        the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant
         *        initialization vector (IV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantInitializationVector(String constantInitializationVector);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * @param spekeKeyProvider
         *        The new value for the SpekeKeyProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the
         * need to create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String constantInitializationVector;

        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafEncryption model) {
            constantInitializationVector(model.constantInitializationVector);
            spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return constantInitializationVector;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        @Override
        public CmafEncryption build() {
            return new CmafEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
