/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.DashEncryption;
import software.amazon.awssdk.services.mediapackagevod.model.DashManifest;
import software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement;
import software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfDashManifestCopier;
import software.amazon.awssdk.services.mediapackagevod.model.___listOf__PeriodTriggersElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashPackage> {
    private static final SdkField<List<DashManifest>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashManifests").getter(DashPackage.getter(DashPackage::dashManifests)).setter(DashPackage.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(DashPackage.getter(DashPackage::encryption)).setter(DashPackage.setter(Builder::encryption)).constructor(DashEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PeriodTriggers").getter(DashPackage.getter(DashPackage::periodTriggersAsStrings)).setter(DashPackage.setter(Builder::periodTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(DashPackage.getter(DashPackage::segmentDurationSeconds)).setter(DashPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentTemplateFormat").getter(DashPackage.getter(DashPackage::segmentTemplateFormatAsString)).setter(DashPackage.setter(Builder::segmentTemplateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentTemplateFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_MANIFESTS_FIELD, ENCRYPTION_FIELD, PERIOD_TRIGGERS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DashManifest> dashManifests;
    private final DashEncryption encryption;
    private final List<String> periodTriggers;
    private final Integer segmentDurationSeconds;
    private final String segmentTemplateFormat;

    private DashPackage(BuilderImpl builder) {
        this.dashManifests = builder.dashManifests;
        this.encryption = builder.encryption;
        this.periodTriggers = builder.periodTriggers;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
    }

    public final boolean hasDashManifests() {
        return this.dashManifests != null && !(this.dashManifests instanceof SdkAutoConstructList);
    }

    public final List<DashManifest> dashManifests() {
        return this.dashManifests;
    }

    public final DashEncryption encryption() {
        return this.encryption;
    }

    public final List<PeriodTriggersElement> periodTriggers() {
        return ___listOf__PeriodTriggersElementCopier.copyStringToEnum(this.periodTriggers);
    }

    public final boolean hasPeriodTriggers() {
        return this.periodTriggers != null && !(this.periodTriggers instanceof SdkAutoConstructList);
    }

    public final List<String> periodTriggersAsStrings() {
        return this.periodTriggers;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public final SegmentTemplateFormat segmentTemplateFormat() {
        return SegmentTemplateFormat.fromValue(this.segmentTemplateFormat);
    }

    public final String segmentTemplateFormatAsString() {
        return this.segmentTemplateFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashManifests() ? this.dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTemplateFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage)obj;
        return this.hasDashManifests() == other.hasDashManifests() && Objects.equals(this.dashManifests(), other.dashManifests()) && Objects.equals(this.encryption(), other.encryption()) && this.hasPeriodTriggers() == other.hasPeriodTriggers() && Objects.equals(this.periodTriggersAsStrings(), other.periodTriggersAsStrings()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DashPackage").add("DashManifests", this.hasDashManifests() ? this.dashManifests() : null).add("Encryption", (Object)this.encryption()).add("PeriodTriggers", this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("SegmentTemplateFormat", (Object)this.segmentTemplateFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "PeriodTriggers": {
                return Optional.ofNullable(clazz.cast(this.periodTriggersAsStrings()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "SegmentTemplateFormat": {
                return Optional.ofNullable(clazz.cast(this.segmentTemplateFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private DashEncryption encryption;
        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;
        private String segmentTemplateFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            this.dashManifests(model.dashManifests);
            this.encryption(model.encryption);
            this.periodTriggersWithStrings(model.periodTriggers);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.segmentTemplateFormat(model.segmentTemplateFormat);
        }

        public final Collection<DashManifest.Builder> getDashManifests() {
            if (this.dashManifests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashManifests != null ? (Collection)this.dashManifests.stream().map(DashManifest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashManifests(Collection<DashManifest> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(DashManifest ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<DashManifest.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (DashManifest)((DashManifest.Builder)DashManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashManifests(Collection<DashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copyFromBuilder(dashManifests);
        }

        public final DashEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<String> getPeriodTriggers() {
            if (this.periodTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.periodTriggers;
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String ... periodTriggers) {
            this.periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(PeriodTriggersElement ... periodTriggers) {
            this.periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentTemplateFormat() {
            return this.segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        public DashPackage build() {
            return new DashPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashPackage> {
        public Builder dashManifests(Collection<DashManifest> var1);

        public Builder dashManifests(DashManifest ... var1);

        public Builder dashManifests(Consumer<DashManifest.Builder> ... var1);

        public Builder encryption(DashEncryption var1);

        default public Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return this.encryption((DashEncryption)((DashEncryption.Builder)DashEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder periodTriggersWithStrings(Collection<String> var1);

        public Builder periodTriggersWithStrings(String ... var1);

        public Builder periodTriggers(Collection<PeriodTriggersElement> var1);

        public Builder periodTriggers(PeriodTriggersElement ... var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder segmentTemplateFormat(String var1);

        public Builder segmentTemplateFormat(SegmentTemplateFormat var1);
    }
}

