/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Exception;
import software.amazon.awssdk.services.mediapackagev2.model.ResourceTypeNotFound;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceNotFoundException
extends MediaPackageV2Exception
implements ToCopyableBuilder<Builder, ResourceNotFoundException> {
    private static final SdkField<String> RESOURCE_TYPE_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceTypeNotFound").getter(ResourceNotFoundException.getter(ResourceNotFoundException::resourceTypeNotFoundAsString)).setter(ResourceNotFoundException.setter(Builder::resourceTypeNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeNotFound").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_NOT_FOUND_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceTypeNotFound;

    private ResourceNotFoundException(BuilderImpl builder) {
        super(builder);
        this.resourceTypeNotFound = builder.resourceTypeNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ResourceTypeNotFound resourceTypeNotFound() {
        return ResourceTypeNotFound.fromValue(this.resourceTypeNotFound);
    }

    public String resourceTypeNotFoundAsString() {
        return this.resourceTypeNotFound;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceNotFoundException, T> g) {
        return obj -> g.apply((ResourceNotFoundException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Exception.BuilderImpl
    implements Builder {
        private String resourceTypeNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceNotFoundException model) {
            super(model);
            this.resourceTypeNotFound(model.resourceTypeNotFound);
        }

        public final String getResourceTypeNotFound() {
            return this.resourceTypeNotFound;
        }

        public final void setResourceTypeNotFound(String resourceTypeNotFound) {
            this.resourceTypeNotFound = resourceTypeNotFound;
        }

        @Override
        public final Builder resourceTypeNotFound(String resourceTypeNotFound) {
            this.resourceTypeNotFound = resourceTypeNotFound;
            return this;
        }

        @Override
        public final Builder resourceTypeNotFound(ResourceTypeNotFound resourceTypeNotFound) {
            this.resourceTypeNotFound(resourceTypeNotFound == null ? null : resourceTypeNotFound.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ResourceNotFoundException build() {
            return new ResourceNotFoundException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceNotFoundException>,
    MediaPackageV2Exception.Builder {
        public Builder resourceTypeNotFound(String var1);

        public Builder resourceTypeNotFound(ResourceTypeNotFound var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

