/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for encrypting content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Encryption implements SdkPojo, Serializable, ToCopyableBuilder<Encryption.Builder, Encryption> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConstantInitializationVector")
            .getter(getter(Encryption::constantInitializationVector))
            .setter(setter(Builder::constantInitializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantInitializationVector")
                    .build()).build();

    private static final SdkField<EncryptionMethod> ENCRYPTION_METHOD_FIELD = SdkField
            .<EncryptionMethod> builder(MarshallingType.SDK_POJO).memberName("EncryptionMethod")
            .getter(getter(Encryption::encryptionMethod)).setter(setter(Builder::encryptionMethod))
            .constructor(EncryptionMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMethod").build()).build();

    private static final SdkField<Integer> KEY_ROTATION_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("KeyRotationIntervalSeconds")
            .getter(getter(Encryption::keyRotationIntervalSeconds))
            .setter(setter(Builder::keyRotationIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRotationIntervalSeconds").build())
            .build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).memberName("SpekeKeyProvider")
            .getter(getter(Encryption::spekeKeyProvider)).setter(setter(Builder::spekeKeyProvider))
            .constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpekeKeyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, KEY_ROTATION_INTERVAL_SECONDS_FIELD,
            SPEKE_KEY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantInitializationVector;

    private final EncryptionMethod encryptionMethod;

    private final Integer keyRotationIntervalSeconds;

    private final SpekeKeyProvider spekeKeyProvider;

    private Encryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    /**
     * <p>
     * A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for
     * encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector
     * (IV).
     * </p>
     * 
     * @return A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for
     *         encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization
     *         vector (IV).
     */
    public final String constantInitializationVector() {
        return constantInitializationVector;
    }

    /**
     * <p>
     * The encryption method to use.
     * </p>
     * 
     * @return The encryption method to use.
     */
    public final EncryptionMethod encryptionMethod() {
        return encryptionMethod;
    }

    /**
     * <p>
     * The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service
     * retrieves content keys before the live content begins streaming, and then retrieves them as needed over the
     * lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation
     * interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.
     * </p>
     * <p>
     * The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
     * </p>
     * 
     * @return The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The
     *         service retrieves content keys before the live content begins streaming, and then retrieves them as
     *         needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the
     *         minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval,
     *         content keys aren't rotated.</p>
     *         <p>
     *         The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
     */
    public final Integer keyRotationIntervalSeconds() {
        return keyRotationIntervalSeconds;
    }

    /**
     * <p>
     * The parameters for the SPEKE key provider.
     * </p>
     * 
     * @return The parameters for the SPEKE key provider.
     */
    public final SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMethod());
        hashCode = 31 * hashCode + Objects.hashCode(keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption) obj;
        return Objects.equals(constantInitializationVector(), other.constantInitializationVector())
                && Objects.equals(encryptionMethod(), other.encryptionMethod())
                && Objects.equals(keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Encryption").add("ConstantInitializationVector", constantInitializationVector())
                .add("EncryptionMethod", encryptionMethod()).add("KeyRotationIntervalSeconds", keyRotationIntervalSeconds())
                .add("SpekeKeyProvider", spekeKeyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantInitializationVector":
            return Optional.ofNullable(clazz.cast(constantInitializationVector()));
        case "EncryptionMethod":
            return Optional.ofNullable(clazz.cast(encryptionMethod()));
        case "KeyRotationIntervalSeconds":
            return Optional.ofNullable(clazz.cast(keyRotationIntervalSeconds()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Encryption, T> g) {
        return obj -> g.apply((Encryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Encryption> {
        /**
         * <p>
         * A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for
         * encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization
         * vector (IV).
         * </p>
         * 
         * @param constantInitializationVector
         *        A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key
         *        for encrypting content. If you don't specify a value, then MediaPackage creates the constant
         *        initialization vector (IV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantInitializationVector(String constantInitializationVector);

        /**
         * <p>
         * The encryption method to use.
         * </p>
         * 
         * @param encryptionMethod
         *        The encryption method to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionMethod(EncryptionMethod encryptionMethod);

        /**
         * <p>
         * The encryption method to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionMethod.Builder} avoiding the
         * need to create one manually via {@link EncryptionMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionMethod.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionMethod(EncryptionMethod)}.
         * 
         * @param encryptionMethod
         *        a consumer that will call methods on {@link EncryptionMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionMethod(EncryptionMethod)
         */
        default Builder encryptionMethod(Consumer<EncryptionMethod.Builder> encryptionMethod) {
            return encryptionMethod(EncryptionMethod.builder().applyMutation(encryptionMethod).build());
        }

        /**
         * <p>
         * The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The
         * service retrieves content keys before the live content begins streaming, and then retrieves them as needed
         * over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum
         * rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys
         * aren't rotated.
         * </p>
         * <p>
         * The following example setting causes the service to rotate keys every thirty minutes: <code>1800</code>
         * </p>
         * 
         * @param keyRotationIntervalSeconds
         *        The frequency (in seconds) of key changes for live workflows, in which content is streamed real time.
         *        The service retrieves content keys before the live content begins streaming, and then retrieves them
         *        as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5
         *        minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter
         *        an interval, content keys aren't rotated.</p>
         *        <p>
         *        The following example setting causes the service to rotate keys every thirty minutes:
         *        <code>1800</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds);

        /**
         * <p>
         * The parameters for the SPEKE key provider.
         * </p>
         * 
         * @param spekeKeyProvider
         *        The parameters for the SPEKE key provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * <p>
         * The parameters for the SPEKE key provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the
         * need to create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String constantInitializationVector;

        private EncryptionMethod encryptionMethod;

        private Integer keyRotationIntervalSeconds;

        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            constantInitializationVector(model.constantInitializationVector);
            encryptionMethod(model.encryptionMethod);
            keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return constantInitializationVector;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final EncryptionMethod.Builder getEncryptionMethod() {
            return encryptionMethod != null ? encryptionMethod.toBuilder() : null;
        }

        public final void setEncryptionMethod(EncryptionMethod.BuilderImpl encryptionMethod) {
            this.encryptionMethod = encryptionMethod != null ? encryptionMethod.build() : null;
        }

        @Override
        public final Builder encryptionMethod(EncryptionMethod encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return keyRotationIntervalSeconds;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        @Override
        public Encryption build() {
            return new Encryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
