/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details about the input device that is being transferred.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransferringInputDeviceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TransferringInputDeviceSummary.Builder, TransferringInputDeviceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(TransferringInputDeviceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(TransferringInputDeviceSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> TARGET_CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCustomerId").getter(getter(TransferringInputDeviceSummary::targetCustomerId))
            .setter(setter(Builder::targetCustomerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCustomerId").build()).build();

    private static final SdkField<String> TRANSFER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransferType").getter(getter(TransferringInputDeviceSummary::transferTypeAsString))
            .setter(setter(Builder::transferType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_FIELD,
            TARGET_CUSTOMER_ID_FIELD, TRANSFER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String message;

    private final String targetCustomerId;

    private final String transferType;

    private TransferringInputDeviceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.message = builder.message;
        this.targetCustomerId = builder.targetCustomerId;
        this.transferType = builder.transferType;
    }

    /**
     * The unique ID of the input device.
     * 
     * @return The unique ID of the input device.
     */
    public final String id() {
        return id;
    }

    /**
     * The optional message that the sender has attached to the transfer.
     * 
     * @return The optional message that the sender has attached to the transfer.
     */
    public final String message() {
        return message;
    }

    /**
     * The AWS account ID for the recipient of the input device transfer.
     * 
     * @return The AWS account ID for the recipient of the input device transfer.
     */
    public final String targetCustomerId() {
        return targetCustomerId;
    }

    /**
     * The type (direction) of the input device transfer.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferType} will
     * return {@link InputDeviceTransferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transferTypeAsString}.
     * </p>
     * 
     * @return The type (direction) of the input device transfer.
     * @see InputDeviceTransferType
     */
    public final InputDeviceTransferType transferType() {
        return InputDeviceTransferType.fromValue(transferType);
    }

    /**
     * The type (direction) of the input device transfer.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferType} will
     * return {@link InputDeviceTransferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transferTypeAsString}.
     * </p>
     * 
     * @return The type (direction) of the input device transfer.
     * @see InputDeviceTransferType
     */
    public final String transferTypeAsString() {
        return transferType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(targetCustomerId());
        hashCode = 31 * hashCode + Objects.hashCode(transferTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferringInputDeviceSummary)) {
            return false;
        }
        TransferringInputDeviceSummary other = (TransferringInputDeviceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(message(), other.message())
                && Objects.equals(targetCustomerId(), other.targetCustomerId())
                && Objects.equals(transferTypeAsString(), other.transferTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransferringInputDeviceSummary").add("Id", id()).add("Message", message())
                .add("TargetCustomerId", targetCustomerId()).add("TransferType", transferTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "TargetCustomerId":
            return Optional.ofNullable(clazz.cast(targetCustomerId()));
        case "TransferType":
            return Optional.ofNullable(clazz.cast(transferTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferringInputDeviceSummary, T> g) {
        return obj -> g.apply((TransferringInputDeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransferringInputDeviceSummary> {
        /**
         * The unique ID of the input device.
         * 
         * @param id
         *        The unique ID of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The optional message that the sender has attached to the transfer.
         * 
         * @param message
         *        The optional message that the sender has attached to the transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * The AWS account ID for the recipient of the input device transfer.
         * 
         * @param targetCustomerId
         *        The AWS account ID for the recipient of the input device transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCustomerId(String targetCustomerId);

        /**
         * The type (direction) of the input device transfer.
         * 
         * @param transferType
         *        The type (direction) of the input device transfer.
         * @see InputDeviceTransferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceTransferType
         */
        Builder transferType(String transferType);

        /**
         * The type (direction) of the input device transfer.
         * 
         * @param transferType
         *        The type (direction) of the input device transfer.
         * @see InputDeviceTransferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceTransferType
         */
        Builder transferType(InputDeviceTransferType transferType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String message;

        private String targetCustomerId;

        private String transferType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferringInputDeviceSummary model) {
            id(model.id);
            message(model.message);
            targetCustomerId(model.targetCustomerId);
            transferType(model.transferType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getTargetCustomerId() {
            return targetCustomerId;
        }

        public final void setTargetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
        }

        @Override
        public final Builder targetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
            return this;
        }

        public final String getTransferType() {
            return transferType;
        }

        public final void setTransferType(String transferType) {
            this.transferType = transferType;
        }

        @Override
        public final Builder transferType(String transferType) {
            this.transferType = transferType;
            return this;
        }

        @Override
        public final Builder transferType(InputDeviceTransferType transferType) {
            this.transferType(transferType == null ? null : transferType.toString());
            return this;
        }

        @Override
        public TransferringInputDeviceSummary build() {
            return new TransferringInputDeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
