/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * SCTE-35 Descriptor settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35DescriptorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35DescriptorSettings.Builder, Scte35DescriptorSettings> {
    private static final SdkField<Scte35SegmentationDescriptor> SEGMENTATION_DESCRIPTOR_SCTE35_DESCRIPTOR_SETTINGS_FIELD = SdkField
            .<Scte35SegmentationDescriptor> builder(MarshallingType.SDK_POJO)
            .memberName("SegmentationDescriptorScte35DescriptorSettings")
            .getter(getter(Scte35DescriptorSettings::segmentationDescriptorScte35DescriptorSettings))
            .setter(setter(Builder::segmentationDescriptorScte35DescriptorSettings))
            .constructor(Scte35SegmentationDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("segmentationDescriptorScte35DescriptorSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SEGMENTATION_DESCRIPTOR_SCTE35_DESCRIPTOR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Scte35SegmentationDescriptor segmentationDescriptorScte35DescriptorSettings;

    private Scte35DescriptorSettings(BuilderImpl builder) {
        this.segmentationDescriptorScte35DescriptorSettings = builder.segmentationDescriptorScte35DescriptorSettings;
    }

    /**
     * SCTE-35 Segmentation Descriptor.
     * 
     * @return SCTE-35 Segmentation Descriptor.
     */
    public final Scte35SegmentationDescriptor segmentationDescriptorScte35DescriptorSettings() {
        return segmentationDescriptorScte35DescriptorSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentationDescriptorScte35DescriptorSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35DescriptorSettings)) {
            return false;
        }
        Scte35DescriptorSettings other = (Scte35DescriptorSettings) obj;
        return Objects.equals(segmentationDescriptorScte35DescriptorSettings(),
                other.segmentationDescriptorScte35DescriptorSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35DescriptorSettings")
                .add("SegmentationDescriptorScte35DescriptorSettings", segmentationDescriptorScte35DescriptorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentationDescriptorScte35DescriptorSettings":
            return Optional.ofNullable(clazz.cast(segmentationDescriptorScte35DescriptorSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35DescriptorSettings, T> g) {
        return obj -> g.apply((Scte35DescriptorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35DescriptorSettings> {
        /**
         * SCTE-35 Segmentation Descriptor.
         * 
         * @param segmentationDescriptorScte35DescriptorSettings
         *        SCTE-35 Segmentation Descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationDescriptorScte35DescriptorSettings(
                Scte35SegmentationDescriptor segmentationDescriptorScte35DescriptorSettings);

        /**
         * SCTE-35 Segmentation Descriptor. This is a convenience method that creates an instance of the
         * {@link Scte35SegmentationDescriptor.Builder} avoiding the need to create one manually via
         * {@link Scte35SegmentationDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35SegmentationDescriptor.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #segmentationDescriptorScte35DescriptorSettings(Scte35SegmentationDescriptor)}.
         * 
         * @param segmentationDescriptorScte35DescriptorSettings
         *        a consumer that will call methods on {@link Scte35SegmentationDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentationDescriptorScte35DescriptorSettings(Scte35SegmentationDescriptor)
         */
        default Builder segmentationDescriptorScte35DescriptorSettings(
                Consumer<Scte35SegmentationDescriptor.Builder> segmentationDescriptorScte35DescriptorSettings) {
            return segmentationDescriptorScte35DescriptorSettings(Scte35SegmentationDescriptor.builder()
                    .applyMutation(segmentationDescriptorScte35DescriptorSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Scte35SegmentationDescriptor segmentationDescriptorScte35DescriptorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35DescriptorSettings model) {
            segmentationDescriptorScte35DescriptorSettings(model.segmentationDescriptorScte35DescriptorSettings);
        }

        public final Scte35SegmentationDescriptor.Builder getSegmentationDescriptorScte35DescriptorSettings() {
            return segmentationDescriptorScte35DescriptorSettings != null ? segmentationDescriptorScte35DescriptorSettings
                    .toBuilder() : null;
        }

        public final void setSegmentationDescriptorScte35DescriptorSettings(
                Scte35SegmentationDescriptor.BuilderImpl segmentationDescriptorScte35DescriptorSettings) {
            this.segmentationDescriptorScte35DescriptorSettings = segmentationDescriptorScte35DescriptorSettings != null ? segmentationDescriptorScte35DescriptorSettings
                    .build() : null;
        }

        @Override
        public final Builder segmentationDescriptorScte35DescriptorSettings(
                Scte35SegmentationDescriptor segmentationDescriptorScte35DescriptorSettings) {
            this.segmentationDescriptorScte35DescriptorSettings = segmentationDescriptorScte35DescriptorSettings;
            return this;
        }

        @Override
        public Scte35DescriptorSettings build() {
            return new Scte35DescriptorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
