/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput;
import software.amazon.awssdk.services.medialive.model.InputDeviceScanType;
import software.amazon.awssdk.services.medialive.model.InputDeviceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceUhdSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceUhdSettings> {
    private static final SdkField<String> ACTIVE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveInput").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::activeInputAsString)).setter(InputDeviceUhdSettings.setter(Builder::activeInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeInput").build()}).build();
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfiguredInput").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::configuredInputAsString)).setter(InputDeviceUhdSettings.setter(Builder::configuredInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()}).build();
    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceState").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::deviceStateAsString)).setter(InputDeviceUhdSettings.setter(Builder::deviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceState").build()}).build();
    private static final SdkField<Double> FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Framerate").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::framerate)).setter(InputDeviceUhdSettings.setter(Builder::framerate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::height)).setter(InputDeviceUhdSettings.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::maxBitrate)).setter(InputDeviceUhdSettings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::scanTypeAsString)).setter(InputDeviceUhdSettings.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::width)).setter(InputDeviceUhdSettings.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final SdkField<Integer> LATENCY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatencyMs").getter(InputDeviceUhdSettings.getter(InputDeviceUhdSettings::latencyMs)).setter(InputDeviceUhdSettings.setter(Builder::latencyMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INPUT_FIELD, CONFIGURED_INPUT_FIELD, DEVICE_STATE_FIELD, FRAMERATE_FIELD, HEIGHT_FIELD, MAX_BITRATE_FIELD, SCAN_TYPE_FIELD, WIDTH_FIELD, LATENCY_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeInput;
    private final String configuredInput;
    private final String deviceState;
    private final Double framerate;
    private final Integer height;
    private final Integer maxBitrate;
    private final String scanType;
    private final Integer width;
    private final Integer latencyMs;

    private InputDeviceUhdSettings(BuilderImpl builder) {
        this.activeInput = builder.activeInput;
        this.configuredInput = builder.configuredInput;
        this.deviceState = builder.deviceState;
        this.framerate = builder.framerate;
        this.height = builder.height;
        this.maxBitrate = builder.maxBitrate;
        this.scanType = builder.scanType;
        this.width = builder.width;
        this.latencyMs = builder.latencyMs;
    }

    public final InputDeviceActiveInput activeInput() {
        return InputDeviceActiveInput.fromValue(this.activeInput);
    }

    public final String activeInputAsString() {
        return this.activeInput;
    }

    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(this.configuredInput);
    }

    public final String configuredInputAsString() {
        return this.configuredInput;
    }

    public final InputDeviceState deviceState() {
        return InputDeviceState.fromValue(this.deviceState);
    }

    public final String deviceStateAsString() {
        return this.deviceState;
    }

    public final Double framerate() {
        return this.framerate;
    }

    public final Integer height() {
        return this.height;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final InputDeviceScanType scanType() {
        return InputDeviceScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final Integer width() {
        return this.width;
    }

    public final Integer latencyMs() {
        return this.latencyMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerate());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceUhdSettings)) {
            return false;
        }
        InputDeviceUhdSettings other = (InputDeviceUhdSettings)obj;
        return Objects.equals(this.activeInputAsString(), other.activeInputAsString()) && Objects.equals(this.configuredInputAsString(), other.configuredInputAsString()) && Objects.equals(this.deviceStateAsString(), other.deviceStateAsString()) && Objects.equals(this.framerate(), other.framerate()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.latencyMs(), other.latencyMs());
    }

    public final String toString() {
        return ToString.builder((String)"InputDeviceUhdSettings").add("ActiveInput", (Object)this.activeInputAsString()).add("ConfiguredInput", (Object)this.configuredInputAsString()).add("DeviceState", (Object)this.deviceStateAsString()).add("Framerate", (Object)this.framerate()).add("Height", (Object)this.height()).add("MaxBitrate", (Object)this.maxBitrate()).add("ScanType", (Object)this.scanTypeAsString()).add("Width", (Object)this.width()).add("LatencyMs", (Object)this.latencyMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveInput": {
                return Optional.ofNullable(clazz.cast(this.activeInputAsString()));
            }
            case "ConfiguredInput": {
                return Optional.ofNullable(clazz.cast(this.configuredInputAsString()));
            }
            case "DeviceState": {
                return Optional.ofNullable(clazz.cast(this.deviceStateAsString()));
            }
            case "Framerate": {
                return Optional.ofNullable(clazz.cast(this.framerate()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "LatencyMs": {
                return Optional.ofNullable(clazz.cast(this.latencyMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceUhdSettings, T> g) {
        return obj -> g.apply((InputDeviceUhdSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeInput;
        private String configuredInput;
        private String deviceState;
        private Double framerate;
        private Integer height;
        private Integer maxBitrate;
        private String scanType;
        private Integer width;
        private Integer latencyMs;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceUhdSettings model) {
            this.activeInput(model.activeInput);
            this.configuredInput(model.configuredInput);
            this.deviceState(model.deviceState);
            this.framerate(model.framerate);
            this.height(model.height);
            this.maxBitrate(model.maxBitrate);
            this.scanType(model.scanType);
            this.width(model.width);
            this.latencyMs(model.latencyMs);
        }

        public final String getActiveInput() {
            return this.activeInput;
        }

        public final void setActiveInput(String activeInput) {
            this.activeInput = activeInput;
        }

        @Override
        public final Builder activeInput(String activeInput) {
            this.activeInput = activeInput;
            return this;
        }

        @Override
        public final Builder activeInput(InputDeviceActiveInput activeInput) {
            this.activeInput(activeInput == null ? null : activeInput.toString());
            return this;
        }

        public final String getConfiguredInput() {
            return this.configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final String getDeviceState() {
            return this.deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        public final Builder deviceState(InputDeviceState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public final Double getFramerate() {
            return this.framerate;
        }

        public final void setFramerate(Double framerate) {
            this.framerate = framerate;
        }

        @Override
        public final Builder framerate(Double framerate) {
            this.framerate = framerate;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(InputDeviceScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getLatencyMs() {
            return this.latencyMs;
        }

        public final void setLatencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
        }

        @Override
        public final Builder latencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public InputDeviceUhdSettings build() {
            return new InputDeviceUhdSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceUhdSettings> {
        public Builder activeInput(String var1);

        public Builder activeInput(InputDeviceActiveInput var1);

        public Builder configuredInput(String var1);

        public Builder configuredInput(InputDeviceConfiguredInput var1);

        public Builder deviceState(String var1);

        public Builder deviceState(InputDeviceState var1);

        public Builder framerate(Double var1);

        public Builder height(Integer var1);

        public Builder maxBitrate(Integer var1);

        public Builder scanType(String var1);

        public Builder scanType(InputDeviceScanType var1);

        public Builder width(Integer var1);

        public Builder latencyMs(Integer var1);
    }
}

