/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceUpdateStatus {
    UP_TO_DATE("UP_TO_DATE"),
    NOT_UP_TO_DATE("NOT_UP_TO_DATE"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceUpdateStatus> VALUE_MAP;
    private final String value;

    private DeviceUpdateStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceUpdateStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceUpdateStatus> knownValues() {
        EnumSet<DeviceUpdateStatus> knownValues = EnumSet.allOf(DeviceUpdateStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceUpdateStatus.class, DeviceUpdateStatus::toString);
    }
}

